from auto_scaling.group.helpers.core_helper import AutoScalingGroupHelper
from auto_scaling.group.helpers.elb_helper import ElbHelper
from auto_scaling.group.helpers.target_group_helper import ASGTargetGroupHelper

from auto_scaling.launch_configuration.helper import LaunchConfigHelper

sg_helper = AutoScalingGroupHelper(deployed)
lc_helper = LaunchConfigHelper(deployed)
elb_helper = ElbHelper(deployed)
tg_helper = ASGTargetGroupHelper(deployed)

lc_helper.create(deployedApplication.version.id)
lc_helper.save_arn()

sg_helper.create()
sg_helper.save_arn()

if elb_helper.are_new_load_balancers_attached():
    elb_helper.attach_load_balancers()

if tg_helper.are_new_target_groups_attached():
    tg_helper.attach_target_groups()
