import commons
from ec2.ec2_helper import EC2Helper


class EBSHelper(EC2Helper):
    def __init__(self, deployed):
        super(EBSHelper, self).__init__(deployed)

    def create_volume(self):
        args = {'VolumeType': self.deployed.volumeType,
                'AvailabilityZone': self.deployed.availabilityZone
                }

        if hasattr(self.deployed, 'size') and self.deployed.size is not None:
            args['Size'] = self.deployed.size

        if hasattr(self.deployed, 'encryption') and self.deployed.encryption is True:
            args['Encrypted'] = self.deployed.encryption

        if hasattr(self.deployed, 'snapshotId') and self.deployed.snapshotId is not None:
            args['SnapshotId'] = self.deployed.snapshotId

        if hasattr(self.deployed, 'volumeType') and self.deployed.volumeType == 'io1' \
            and hasattr(self.deployed, 'iops') and self.deployed.iops:
            args['Iops'] = self.deployed.iops

        if hasattr(self.deployed, 'encryption') and self.deployed.encryption is True \
            and hasattr(self.deployed, 'kmsKeyId') and self.deployed.kmsKeyId is not None:
            args['KmsKeyId'] = self.deployed.kmsKeyId

        response = self.ec2_client.create_volume(**args)

        self.set_volume_name(response['VolumeId'],
                             self.deployed.volumeName if self.deployed.volumeName else self.deployed.name)
        return response

    def set_volume_name(self, volume_id, volume_name):
        self.ec2_client.create_tags(DryRun=False, Resources=[volume_id],
                                    Tags=[{'Key': 'Name', 'Value': volume_name}])

    def delete_volume(self):
        self.ec2_client.delete_volume(DryRun=False, VolumeId=self.deployed.volumeId)

    def get_volume_id(self, volume_name):
        response = self.ec2_client.describe_volumes(DryRun=False,
                                                    Filters=[{'Name': 'tag:Name', 'Values': [volume_name]}])
        if response['ResponseMetadata']['HTTPStatusCode'] != 200 or len(response['Volumes']) == 0:
            raise RuntimeError("No Volume found with name %s" % volume_name)
        elif len(response['Volumes']) > 1:
            raise RuntimeError("Multiple Volume found with name %s" % volume_name)

        return response['Volumes'][0]['VolumeId']

    def is_volume_created(self):
        response = self.ec2_client.describe_volumes(DryRun=False,
                                                    VolumeIds=[self.deployed.volumeId])
        if response['ResponseMetadata']['HTTPStatusCode'] != 200 or len(response['Volumes']) == 0:
            raise RuntimeError("No Volume found with id %s" % self.deployed.volumeId)
        elif len(response['Volumes']) > 1:
            raise RuntimeError("Multiple Volume found with id %s" % self.deployed.volumeId)
        else:
            return response['Volumes'][0]['State'] == 'available'
