import time

from auto_scaling.group.builders.asg_builder import AsgParamsBuilder
from commons.aws_helper import AWSHelper
from ec2.ec2_helper import EC2Helper


class AutoScalingGroupHelper(AWSHelper):
    def __init__(self, deployed, previous_deployed=None):
        super(AutoScalingGroupHelper, self).__init__(deployed)
        self.__client = self.get_aws_client(region=deployed.region, resource_name='autoscaling')
        self.__ec2_helper = EC2Helper(deployed)
        self.__previous_deployed = previous_deployed
        self.__builder = AsgParamsBuilder(deployed)

    def create(self):
        print "Creating auto scaling group {0} on {1}".format(self.get_asg_name(),
                                                              self.deployed.container.name)
        params = AWSHelper.remove_empty_and_none_values(self.__builder.build_create_params())
        return self.__client.create_auto_scaling_group(**params)

    def __get_by_name(self):
        return self.__client.describe_auto_scaling_groups(
            AutoScalingGroupNames=[self.get_asg_name()]
        )

    def save_arn(self):
        arn = self.__get_by_name()['AutoScalingGroups'][0]['AutoScalingGroupARN']
        self.deployed.asgArn = arn

    def update(self, params=None):
        print "Updating auto scaling group {0} on {1}".format(self.get_asg_name(),
                                                              self.deployed.container.name)
        params = params if bool(params) else self.__builder.build_update_params()
        filtered_params = AWSHelper.remove_empty_and_none_values(params)
        return self.__client.update_auto_scaling_group(**filtered_params)

    def delete(self):
        print "Deleting auto scaling group {0} on {1}".format(self.get_asg_name(),
                                                              self.__previous_deployed.container.name)
        return self.__client.delete_auto_scaling_group(
            AutoScalingGroupName=self.get_asg_name(),
            ForceDelete=True
        )

    def wait_for_complete_destroy(self):
        for count in range(0, self.deployed.maxRetriesForASGToBeDestroyed, 1):
            print "Waiting for auto scaling group {0} to be completely destroyed".format(
                self.get_asg_name())
            response = self.__get_by_name()
            if bool(response['AutoScalingGroups']):
                time.sleep(5)
            else:
                print "Auto scaling group {0} destroyed".format(self.get_asg_name())
                break
            if count == self.__previous_deployed.maxRetriesForASGToBeDestroyed:
                raise Exception(
                    "Auto scaling group {0} could not be destroyed in stipulated time".format(self.get_asg_name()))
        return False

    def get_asg_name(self):
        return self.deployed.autoScalingGroupName if bool(self.deployed.autoScalingGroupName) else self.deployed.name
