from rds.subnet_group.utils import RDSSubnetGroupUtils

sg_utils = RDSSubnetGroupUtils(deployed=deployed, previous_deployed=previousDeployed)

if bool(sg_utils.is_subnet_group_modified()):
    if bool(sg_utils.get_deleted_subnets()):
        deleted_subnets = sg_utils.get_collection_pretty_printed(sg_utils.get_deleted_subnets())

        context.addStep(steps.jython(
            description="Dissociate subnets {0} from Subnet Group {1} on {2}".format(deleted_subnets, deployed.subnetGroupName, deployed.container.name),
            script="rds/subnet_group/dissociate_subnets.py",
            jython_context = {"delete_subnets_pretty_printed" : deleted_subnets},
            order=39
        ))

    if sg_utils.are_subnets_added() or \
        sg_utils.is_description_modified() or \
        sg_utils.are_tags_modified():

        context.addStep(steps.jython(
            description="Modify Subnet Group {0} on {1}".format(deployed.subnetGroupName, deployed.container.name),
            script="rds/subnet_group/modify_attributes.py",
            order=63
        ))
