/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClientBuilder;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.DeadLetterConfig;
import com.amazonaws.services.lambda.model.Environment;
import com.amazonaws.services.lambda.model.FunctionCode;
import com.amazonaws.services.lambda.model.TracingConfig;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeResult;
import com.amazonaws.services.lambda.model.VpcConfig;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LambdaZipHelper {
    private String accessKey;
    private String secretKey;
    private String sessionToken;
    private String region;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;

    public LambdaZipHelper(String accessKey, String secretKey, String sessionToken, String region) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.sessionToken = sessionToken;
        this.region = region;
    }

    public LambdaZipHelper(String accessKey, String secretKey, String sessionToken, String region, String proxyHost, Integer proxyPort, String proxyUsername, String proxyPassword) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.sessionToken = sessionToken;
        this.region = region;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
    }

    public AWSLambda createClient() {
        AWSLambdaClientBuilder clientBuilder = null;
        clientBuilder = this.sessionToken != null ? (this.accessKey != null && this.secretKey != null ? (AWSLambdaClientBuilder)AWSLambdaClientBuilder.standard().withCredentials(new AWSCredentialsProvider(){

            public AWSCredentials getCredentials() {
                return new BasicSessionCredentials(LambdaZipHelper.this.accessKey, LambdaZipHelper.this.secretKey, LambdaZipHelper.this.sessionToken);
            }

            public void refresh() {
            }
        }) : (AWSLambdaClientBuilder)AWSLambdaClientBuilder.standard().withRegion(this.region)) : (this.accessKey != null && this.secretKey != null ? (AWSLambdaClientBuilder)AWSLambdaClientBuilder.standard().withCredentials(new AWSCredentialsProvider(){

            public AWSCredentials getCredentials() {
                return new BasicAWSCredentials(LambdaZipHelper.this.accessKey, LambdaZipHelper.this.secretKey);
            }

            public void refresh() {
            }
        }) : (AWSLambdaClientBuilder)AWSLambdaClientBuilder.standard().withRegion(this.region));
        if (null != this.proxyHost && null != this.proxyPort) {
            ClientConfiguration clientConfig = new ClientConfiguration();
            clientConfig.setProxyHost(this.proxyHost);
            clientConfig.setProxyPort(this.proxyPort.intValue());
            if (null != this.proxyUsername && null != this.proxyPassword) {
                clientConfig.setProxyUsername(this.proxyUsername);
                clientConfig.setProxyPassword(this.proxyPassword);
            }
            clientBuilder.setClientConfiguration(clientConfig);
        }
        AWSLambda client = (AWSLambda)((AWSLambdaClientBuilder)clientBuilder.withRegion(Regions.fromName((String)this.region))).build();
        return client;
    }

    public CreateFunctionResult createZipFunction(CreateFunctionRequest request, String file) throws Exception {
        AWSLambda client = this.createClient();
        request.setCode(new FunctionCode().withZipFile(this.readFile(file)));
        return client.createFunction(request);
    }

    public UpdateFunctionCodeResult updateFunctionCode(UpdateFunctionCodeRequest request, String file) throws Exception {
        AWSLambda client = this.createClient();
        request.setZipFile(this.readFile(file));
        return client.updateFunctionCode(request);
    }

    public CreateFunctionRequest buildCreateFunctionRequest() {
        return new CreateFunctionRequest();
    }

    public void addEnvironmentVariable(CreateFunctionRequest request, String key, String value) {
        if (request.getEnvironment() == null) {
            request.setEnvironment(new Environment());
        }
        request.getEnvironment().addVariablesEntry(key, value);
    }

    public void addTag(CreateFunctionRequest request, String key, String value) {
        request.getTags().put(key, value);
    }

    public void addSecurityGroupId(CreateFunctionRequest request, String securityGroupId) {
        if (request.getVpcConfig() == null) {
            request.setVpcConfig(new VpcConfig());
        }
        request.getVpcConfig().getSecurityGroupIds().add(securityGroupId);
    }

    public void addSubnetId(CreateFunctionRequest request, String subnetId) {
        if (request.getVpcConfig() == null) {
            request.setVpcConfig(new VpcConfig());
        }
        request.getVpcConfig().getSubnetIds().add(subnetId);
    }

    public void setDeadLetterConfig(CreateFunctionRequest request, String targetArn) {
        request.setDeadLetterConfig(new DeadLetterConfig().withTargetArn(targetArn));
    }

    public void setTracingConfig(CreateFunctionRequest request, String mode) {
        request.setTracingConfig(new TracingConfig().withMode(mode));
    }

    public UpdateFunctionCodeRequest buildUpdateFunctionCodeRequest() {
        return new UpdateFunctionCodeRequest();
    }

    private ByteBuffer readFile(String file) throws Exception {
        Path path = Paths.get(file, new String[0]);
        byte[] fileContents = Files.readAllBytes(path);
        return ByteBuffer.wrap(fileContents);
    }
}

