from auto_scaling.group.builders.asg_builder import AsgParamsBuilder
from auto_scaling.group.helpers.core_helper import AutoScalingGroupHelper
from auto_scaling.group.helpers.elb_helper import ElbHelper
from auto_scaling.group.helpers.target_group_helper import ASGTargetGroupHelper
from auto_scaling.group.helpers.vpc_helper import VpcHelper

sg_helper = AutoScalingGroupHelper(deployed, previousDeployed)
vpc_helper = VpcHelper(deployed, previousDeployed)
tg_helper = ASGTargetGroupHelper(deployed, previousDeployed)
elb_helper = ElbHelper(deployed, previousDeployed)
builder = AsgParamsBuilder(deployed)

if elb_helper.are_load_balancers_detached():
    elb_helper.detach_load_balancers()

if tg_helper.are_target_groups_detached():
    tg_helper.detach_target_groups()

if bool(vpc_helper.are_subnets_detached() or vpc_helper.are_availability_zones_detached()):
    params = builder.build_dissociation_params(subnets=vpc_helper.get_remaining_subnets(),
                                               availability_zones=vpc_helper.get_remaining_availability_zones())
    sg_helper.update(params)
