from ec2.instance.ec2_instance_helper import EC2InstanceHelper

ec2_helper = EC2InstanceHelper(deployed)

instance_id = previousDeployed.instanceId
if previousDeployed.iAmRoleARN and previousDeployed.iAmRoleARN != deployed.iAmRoleARN:
    ec2_helper.modify_iam_instance_profile(instance_id)
elif not previousDeployed.iAmRoleARN and previousDeployed.iAmRoleARN != deployed.iAmRoleARN:
    ec2_helper.associate_iam_instance_profile(instance_id)
if previousDeployed.detailedMonitoring != deployed.detailedMonitoring:
    if deployed.detailedMonitoring:
        ec2_helper.enable_detailed_monitoring(instance_id)
    else:
        ec2_helper.disable_detailed_monitoring(instance_id)
if previousDeployed.tenancy != deployed.tenancy:
    ec2_helper.modify_tenancy(instance_id, deployed.tenancy)

if previousDeployed.shutdownBehavior != deployed.shutdownBehavior:
    ec2_helper.modify_instance_attribute(instance_id, 'InstanceInitiatedShutdownBehavior', deployed.shutdownBehavior)
if previousDeployed.userData != deployed.userData:
    user_data = deployed.userData if deployed.userData else ''
    ec2_helper.modify_instance_attribute(instance_id, 'UserData', user_data)
if previousDeployed.terminationProtection != deployed.terminationProtection:
    ec2_helper.modify_instance_attribute(instance_id, 'DisableApiTermination', deployed.terminationProtection)
if previousDeployed.instanceType != deployed.instanceType:
    ec2_helper.modify_instance_attribute(instance_id, 'InstanceType', deployed.instanceType)
if previousDeployed.instanceName != deployed.instanceName:
    ec2_helper.set_resource_name(previousDeployed.instanceId, deployed.instanceName if deployed.instanceName else deployed.name)

# Delete tags
for key, value in previousDeployed.instanceTags.items():
    if key not in deployed.instanceTags.keys():
        ec2_helper.delete_ec2_tag(instance_id, key, value)

# Add and modify new tags
for key, value in deployed.instanceTags.items():
    if key in previousDeployed.instanceTags.keys() and previousDeployed.instanceTags.get(key) == value:
        pass
    else:
        ec2_helper.create_ec2_tag(instance_id, key, value)
