from ec2.ec2_helper import EC2Helper
from ec2.vpc.vpc_helper import VPCHelper


class SNHelper(EC2Helper):
    def __init__(self, deployed):
        super(SNHelper, self).__init__(deployed)
        self.vpc_helper = VPCHelper(deployed)

    def create_subnet(self):
        params = self.get_subnet_params()
        create_sn_response = self.ec2_client.create_subnet(**params)
        if create_sn_response['ResponseMetadata']['HTTPStatusCode'] == 200:
            self.deployed.subnetId = create_sn_response['Subnet']['SubnetId']
        return create_sn_response

    def delete_subnet(self):
        delete_sn_response = self.ec2_client.delete_subnet(
            SubnetId=self.deployed.subnetId
        )
        return delete_sn_response

    def modify_auto_assign_public_ip(self):
        modify_sn_response = self.ec2_client.modify_subnet_attribute(
            SubnetId=self.deployed.subnetId,
            MapPublicIpOnLaunch={
                'Value': self.deployed.mapPublicIpOnLaunch
            })
        return modify_sn_response

    def modify_auto_assign_ipv6_address(self):
        modify_sn_response = self.ec2_client.modify_subnet_attribute(
            SubnetId=self.deployed.subnetId,
            AssignIpv6AddressOnCreation={
                'Value': self.deployed.assignIpv6AddressOnCreation
            })
        return modify_sn_response

    def get_subnet_params(self):
        if self.is_starts_with_name(self.deployed.vpc):
            vpc_id = self.vpc_helper.get_vpc_id_by_name(self.get_property_name(self.deployed.vpc))
        else:
            vpc_id = self.deployed.vpc

        params_dict = {'VpcId': vpc_id}
        if self.deployed.cidrBlock:
            params_dict['CidrBlock'] = self.deployed.cidrBlock
        if self.deployed.ipv6CidrBlock:
            params_dict['Ipv6CidrBlock'] = self.deployed.ipv6CidrBlock
        if self.deployed.availabilityZone:
            params_dict['AvailabilityZone'] = self.deployed.availabilityZone
        return params_dict

    def is_subnet_available(self, subnet_id):
        try:
            subnets = self.ec2_client.describe_subnets(SubnetIds=[subnet_id])["Subnets"]
            if subnets[0]["State"] == "available":
                return True
        except:
            return False
