from ec2.sg.sg_helper import SGHelper

sg_helper = SGHelper(deployed)

# Steps to remove rules for modify event
if previousDeployed:
    if deployed.securityGroupName != previousDeployed.securityGroupName:
        raise RuntimeError("Security group name can not be updated once created.")
    if deployed.description != previousDeployed.description:
        raise RuntimeError("Security group description can not be updated once created.")

    if previousDeployed.inboundRules and len(previousDeployed.inboundRules) > 0:
        context.addStepWithCheckpoint(steps.jython(
            description="Remove inbound rules from security group %s on %s" % (previousDeployed.securityGroupName if previousDeployed.securityGroupName else previousDeployed.name, previousDeployed.container.name),
            script="ec2/sg/remove_inbound_rules.py",
            order=53
        ), delta)

    if previousDeployed.outboundRules and len(previousDeployed.outboundRules) > 0:
        context.addStepWithCheckpoint(steps.jython(
            description="Remove outbound rules from security group %s on %s" % (previousDeployed.securityGroupName if previousDeployed.securityGroupName else previousDeployed.name, previousDeployed.container.name),
            script="ec2/sg/remove_outbound_rules.py",
            order=53
        ), delta)

# Steps to add rules for create event
else:
    context.addStepWithCheckpoint(steps.jython(
        description="Create security group %s on %s" % (deployed.securityGroupName if deployed.securityGroupName else deployed.name, deployed.container.name),
        script="ec2/sg/create_security_group.py",
        order=53
    ), delta)

    context.addStepWithCheckpoint(steps.jython(
        description="Apply properties to security group %s on %s" % (deployed.securityGroupName if deployed.securityGroupName else deployed.name, deployed.container.name),
        script="ec2/sg/apply_security_group_properties.py",
        order=55
    ), delta)


# Steps to add rules for create or modify event
if deployed.inboundRules and len(deployed.inboundRules) > 0:
    is_vpc_not_provided = not sg_helper.is_vpc_provided()
    for rule in deployed.inboundRules:
        if is_vpc_not_provided:
            if rule.protocol == "-1":
                raise RuntimeError("Protocol -1 is not allowed for non VPC security group in inbound rule %s.", rule.name)
            if sg_helper.is_ipv6_cidr(rule.source):
                raise RuntimeError("IPv6 source is not allowed for non VPC security group in inbound rule %s.", rule.name)
        if not sg_helper.is_valid_port_range(rule.portRange):
            raise RuntimeError("Port range is not valid in inbound rule %s.", rule.name)

    context.addStepWithCheckpoint(steps.jython(
        description="Add inbound rules to security group %s on %s" % (deployed.securityGroupName if deployed.securityGroupName else deployed.name, deployed.container.name),
        script="ec2/sg/add_inbound_rules.py",
        order=54
    ), delta)

if deployed.outboundRules and len(deployed.outboundRules) > 0:
    if not sg_helper.is_vpc_provided():
        raise RuntimeError("Outbound rules are not allowed for non VPC security group.")

    for rule in deployed.outboundRules:
        if not sg_helper.is_valid_port_range(rule.portRange):
            raise RuntimeError("Port range is not valid in outbound rule %s.", rule.name)

    context.addStepWithCheckpoint(steps.jython(
        description="Add outbound rules to security group %s on %s" % (deployed.securityGroupName if deployed.securityGroupName else deployed.name, deployed.container.name),
        script="ec2/sg/add_outbound_rules.py",
        order=54
    ), delta)
