from s3.s3_bucket_helper import S3Helper

s3_helper = S3Helper(deployed)
if not previousDeployed:
    create_response = s3_helper.create_s3_bucket()

    # Static website endpoint is available without even setting the static website properties,
    # forming endpoint url here using bucket name and region.
    if create_response['ResponseMetadata']['HTTPStatusCode'] == 200:
        print "S3 bucket created."
        url = "%s.s3-website-%s.amazonaws.com" % (deployed.bucketName, deployed.region)
        deployed.endpoint = url

if deployed.logging:
    logging_response = s3_helper.set_bucket_logging()
elif previousDeployed and previousDeployed.logging:
    logging_response = s3_helper.disable_bucket_logging()

if deployed.staticWebsiteHosting:
    hosting_response = s3_helper.set_bucket_website_hosting()
elif previousDeployed and previousDeployed.staticWebsiteHosting:
    logging_response = s3_helper.disable_bucket_website_hosting()
