import commons
from botocore.session import Session as BotocoreSession

from boto3.session import Session
import mimetypes

class S3Helper(object):
    def __init__(self, deployed):
        self.deployed = deployed
        botocore_session = BotocoreSession()
        botocore_session.lazy_register_component('data_loader',
                                                 lambda: commons.create_loader())

        cloud = deployed.container.container
        self.session = Session(aws_access_key_id=cloud.accesskey,
                               aws_secret_access_key=cloud.accessSecret,
                               botocore_session=botocore_session)

        self.s3 = self.session.resource('s3', use_ssl=False)
        self.s3_client = self.session.client('s3', use_ssl=False)

    def upload_file_on_bucket(self, key, acl, file):
        mime_type = mimetypes.guess_type(file.name)[0]
        return self.upload_file(acl, file, key, mime_type)

    def upload_file(self, acl, file, key, mime_type=None):
        upload_params = {'ACL': acl,
                         'Bucket': self.deployed.container.bucketName,
                         'Key': key,
                         'Body': file}
        if mime_type:
            upload_params.update({'ContentType': mime_type})
        return self.s3_client.put_object(**upload_params)

    def delete_file_from_bucket(self, key):
        hosting_response = self.s3_client.delete_object(
            Bucket=self.deployed.container.bucketName, Key=key)
        return hosting_response
