#
if previousDeployed:
    if deployed.region != previousDeployed.region:
        raise RuntimeError("Network interface region can not be updated after creation.")
    if deployed.subnet != previousDeployed.subnet:
        raise RuntimeError("Network interface subnet can not be updated after creation.")
    if deployed.primaryIpAddress != previousDeployed.primaryIpAddress:
        raise RuntimeError("Network interface primary IP address can not be updated after creation.")
    if deployed.networkInterfaceId != previousDeployed.networkInterfaceId:
        raise RuntimeError("Network interface Id can not be updated after creation.")
    description = "Modify network interface %s on %s" % (
        previousDeployed.networkInterfaceName if previousDeployed.networkInterfaceName else previousDeployed.name,
        deployed.container.name)
else:
    description = "Create network interface %s on %s" % (
        deployed.networkInterfaceName if deployed.networkInterfaceName else deployed.name, deployed.container.name)

context.addStepWithCheckpoint(steps.jython(
    description=description,
    script="ec2/ni/create_modify_network_interface.py",
    order=56
), delta)
