from elb.elb_validator import ElbValidator

validator = ElbValidator(deployed=deployed, previous_deployed=previousDeployed)

validator.should_not_modify_load_balancer_name()
validator.should_not_modify_scheme()
validator.should_have_minimum_listeners(1)
validator.should_not_have_multiple_listeners_with_same_load_balancer_port()
validator.should_have_at_least_one_security_group_unmodified()
validator.should_have_at_least_one_subnet_unmodified()
validator.should_not_have_listeners_with_multiple_policies_defined()

if validator.should_dissociate_resources():
    context.addStep(steps.jython(
        description="Dissociate resources from ELB %s on %s" % (deployed.loadBalancerName, deployed.container.name),
        script="elb/steps/dissociate_resources.py",
        order=43
    ))

    context.addStep(steps.wait(
        description="Wait for dissociation of resources from ELB %s on %s to be completed" % (
            deployed.loadBalancerName, deployed.container.name),
        order=44,
        seconds=deployed.resourceDissociationWaitTime
    ))
context.addStep(steps.jython(
    description="Delete listeners and policies from ELB %s on %s" % (
        previousDeployed.loadBalancerName, previousDeployed.container.name),
    script="elb/steps/detach_listeners.py",
    order=45
))

if validator.should_associate_resources():
    context.addStep(steps.jython(
        description="Associate resources to ELB %s on %s" % (deployed.loadBalancerName, deployed.container.name),
        script="elb/steps/associate_resources.py",
        order=67
    ))

context.addStep(steps.jython(
    description="Create listeners and policies on ELB %s on %s" % (deployed.loadBalancerName, deployed.container.name),
    script="elb/steps/attach_listeners.py",
    order=68
))
