if previousDeployed.cidrBlock != deployed.cidrBlock:
    raise RuntimeError("CIDR block of a VPC cannot be modified.")
if previousDeployed.instanceTenancy != deployed.instanceTenancy:
    raise RuntimeError("Instance tenancy of a VPC cannot be modified.")
if previousDeployed.region != deployed.region:
    raise RuntimeError("Region of a VPC cannot be modified.")

if previousDeployed.vpcName != deployed.vpcName or \
        previousDeployed.amazonProvidedIpv6CidrBlock != deployed.amazonProvidedIpv6CidrBlock or \
        previousDeployed.classicLink != deployed.classicLink or \
        previousDeployed.classicLinkDnsSupport != deployed.classicLinkDnsSupport or \
        previousDeployed.dnsSupport != deployed.dnsSupport or \
        previousDeployed.dnsHostnames != deployed.dnsHostnames:

    context.addStep(steps.jython(
        description="Modify properties of VPC %s on %s" % (previousDeployed.vpcName if previousDeployed.vpcName else previousDeployed.name, deployed.container.name),
        script="ec2/vpc/modify.py",
        order=52
    ))

# Adding internet gateway steps
vpc_name = deployed.vpcName if deployed.vpcName else deployed.name
gateway_name = deployed.internetGatewayName if deployed.internetGatewayName else vpc_name + '-gateway'

previous_vpc_name = previousDeployed.vpcName if previousDeployed.vpcName else previousDeployed.name
previous_gateway_name = previousDeployed.internetGatewayName if previousDeployed.internetGatewayName else previous_vpc_name + '-gateway'

if deployed.createInternetGateway != previousDeployed.createInternetGateway:
    if deployed.createInternetGateway:
        context.addStepWithCheckpoint(steps.jython(
            description="Create internet gateway %s in %s" % (gateway_name, deployed.container.name),
            script="ec2/ig/create_internet_gateway.py",
            order=53
        ), delta)
        context.addStep(steps.jython(
            description="Wait for internet gateway %s to be available in %s" % (gateway_name, deployed.container.name),
            script="ec2/ig/wait_internet_gateway_available.py",
            order=54
        ))
        context.addStep(steps.jython(
            description="Apply properties to internet gateway %s in %s" % (gateway_name, deployed.container.name),
            script="ec2/ig/apply_internet_gateway_properties.py",
            order=55
        ))
        context.addStepWithCheckpoint(steps.jython(
            description="Attach internet gateway %s to VPC %s in %s" % (gateway_name, vpc_name, deployed.container.name),
            script="ec2/ig/attach_internet_gateway.py",
            order=56
        ), delta)
    else:
        description = "Detach internet gateway %s from VPC %s in %s" % (previous_gateway_name, previous_vpc_name, previousDeployed.container.name)
        context.addStepWithCheckpoint(steps.jython(
            description=description,
            script="ec2/ig/detach_internet_gateway.py",
            order=47
        ), delta)
        description = "Destroy internet gateway %s from %s" % (previous_gateway_name, previousDeployed.container.name)
        context.addStepWithCheckpoint(steps.jython(
            description=description,
            script="ec2/ig/delete_internet_gateway.py",
            order=48
        ), delta)
else:
    # check if gateway name is changed and gateway was created
    if previous_gateway_name != gateway_name and previousDeployed.createInternetGateway:
        context.addStep(steps.jython(
            description="Apply properties to internet gateway %s in %s" % (gateway_name, deployed.container.name),
            script="ec2/ig/apply_internet_gateway_properties.py",
            order=55
        ))

previous_peers = set(previousDeployed.peerVPCs) if hasattr(previousDeployed, "peerVPCs") and previousDeployed.peerVPCs else set()
peers = set(deployed.peerVPCs) if hasattr(deployed, "peerVPCs") and deployed.peerVPCs else set()

# Adding peering connection deletion steps
peers_to_delete = previous_peers - peers
if peers_to_delete:
    context.addStepWithCheckpoint(steps.jython(
        description="Destroy peer connection for VPC %s in %s" % (vpc_name, previousDeployed.container.name),
        script="ec2/vpc/destroy_peer_connection.py",
        order=48,
        jython_context = {"peer_vpcs": peers_to_delete}
    ), delta)

# Adding peering connection deletion steps
peers_to_add = peers - previous_peers
if peers_to_add:
    context.addStepWithCheckpoint(steps.jython(
        description="Create peer connection for VPC %s in %s" % (vpc_name, deployed.container.name),
        script="ec2/vpc/create_peer_connection.py",
        order=53,
        jython_context = {"peer_vpcs": peers_to_add}
    ), delta)



