if deployed.region != previousDeployed.region:
    raise RuntimeError("Repository region cannot be updated once created.")

if deployed.repositoryName != previousDeployed.repositoryName:
    raise RuntimeError("Repository name cannot be updated once created.")

if deployed.policy != previousDeployed.policy:
    if not bool(deployed.policy) or not len(deployed.policy.strip()) > 0:
        context.addStepWithCheckpoint(steps.jython(
            description="Remove policy on repository {}".format(deployed.repositoryName if deployed.repositoryName else deployed.name),
            script="ecr/delete_policy.py",
            order=54
        ), delta)
    else:
        context.addStepWithCheckpoint(steps.jython(
            description="Apply policy on repository {}".format(deployed.repositoryName if deployed.repositoryName else deployed.name),
            script="ecr/set_policy.py",
            order=55
        ), delta)

