from auto_scaling.group.helpers.core_helper import AutoScalingGroupHelper
from auto_scaling.group.validator import AutoScalingValidator

validator = AutoScalingValidator(deployed, previousDeployed)
asg_helper = AutoScalingGroupHelper(deployed)
validator.should_not_modify_subnets()
validator.should_not_modify_availability_zones()

if validator.are_resources_dissociated():
    context.addStepWithCheckpoint(steps.jython(
        description="Dissociate resources from auto scaling group {0} on {1}".format(
            asg_helper.get_asg_name(),
            deployed.container.name),
        script="auto_scaling/group/steps/dissociate_resources.py",
        order=40
    ), delta)

if validator.are_resources_associated():
    context.addStepWithCheckpoint(steps.jython(
        description="Associate resources to auto scaling group {0} on {1}".format(asg_helper.get_asg_name(),
                                                                                  deployed.container.name),
        script="auto_scaling/group/steps/associate_resources.py",
        order=66,
        jython_context={'version_id': deployedApplication.version.id}
    ), delta)

if validator.are_properties_modified():
    context.addStepWithCheckpoint(steps.jython(
        description="Apply/Modify properties of auto scaling group {0} on {1}".format(asg_helper.get_asg_name(),
                                                                                      deployed.container.name),
        script="auto_scaling/group/steps/apply_properties.py",
        order=66
    ), delta)
