from rds.security_group.helper import RDSSecurityGroupHelper

RDSSecurityGroupHelper(deployed).validate_security_group_modification(previousDeployed)
cidr_to_remove = list(set(previousDeployed.cidrIPs) - set(deployed.cidrIPs))
ec2_sg_to_remove = list(set(previousDeployed.ec2SecurityGroups) - set(deployed.ec2SecurityGroups))

if len(cidr_to_remove) > 0 or len(ec2_sg_to_remove) > 0:
    context.addStepWithCheckpoint(steps.jython(
        description="Detaching authorizations from DB security group {0}".format(previousDeployed.securityGroupName),
        script="rds/security_group/detach_auth.py",
        order=57,
        jython_context = {"cidrips": cidr_to_remove, "ec2securitygroups": ec2_sg_to_remove}
    ), delta)
    context.addStep(steps.jython(
        description="Wait for authorizations to be removed on DB security group {0}".format(previousDeployed.securityGroupName),
        script="rds/security_group/wait_detach_auth.py",
        order=58,
        jython_context = {"cidrips": cidr_to_remove, "ec2securitygroups": ec2_sg_to_remove}
    ))

cidr_to_add = list(set(deployed.cidrIPs) - set(previousDeployed.cidrIPs))
ec2_sg_to_add = list(set(deployed.ec2SecurityGroups) - set(previousDeployed.ec2SecurityGroups))

if len(cidr_to_add) > 0 or len(ec2_sg_to_add) > 0:
    context.addStepWithCheckpoint(steps.jython(
        description="Attaching authorizations to DB security group {0}".format(previousDeployed.securityGroupName),
        script="rds/security_group/attach_auth.py",
        order=59,
        jython_context = {"cidrips": cidr_to_add, "ec2securitygroups": ec2_sg_to_add}
    ), delta)
    context.addStep(steps.jython(
        description="Wait for authorizations to be applied on DB security group {0}".format(previousDeployed.securityGroupName),
        script="rds/security_group/wait_attach_auth.py",
        order=60
    ))
