class PolicyHelper:
    def __init__(self, deployed, previous_deployed=None):
        self.__previous_deployed = previous_deployed
        self.__deployed = deployed

    def are_new_termination_policies_attached(self):
        return bool(self.get_new_attached_termination_policies())

    def get_new_attached_termination_policies(self):
        return (self.__deployed.terminationPolicies - self.__previous_deployed.terminationPolicies) if bool(
            self.__previous_deployed) else self.__deployed.terminationPolicies

    def are_termination_policies_detached(self):
        return bool(self.get_detached_termination_policies())

    def get_detached_termination_policies(self):
        return self.__previous_deployed.terminationPolicies - self.__deployed.terminationPolicies
