from ec2.ec2_helper import EC2Helper
from rds.rds_helper import RDSHelper


class RDSSubnetGroupHelper(RDSHelper):
    def __init__(self, deployed, previous_deployed=None):
        super(RDSSubnetGroupHelper, self).__init__(deployed)
        self.__deployed = deployed
        self.__ec2_helper = EC2Helper(deployed)
        self.__previous_deployed = previous_deployed

    def create(self):
        return self.rds_client.create_db_subnet_group(
            DBSubnetGroupName=self.__deployed.subnetGroupName,
            DBSubnetGroupDescription=self.__deployed.description,
            SubnetIds=self.__ec2_helper.get_subnet_id_list(self.__deployed.subnets),
            Tags=RDSHelper.get_tags(self.deployed.subnetGroupsTags)
        )

    def delete(self):
        return self.rds_client.delete_db_subnet_group(
            DBSubnetGroupName=self.__previous_deployed.subnetGroupName
        )

    def modify(self, subnets):
        return self.rds_client.modify_db_subnet_group(
            DBSubnetGroupName=self.__deployed.subnetGroupName,
            DBSubnetGroupDescription=self.__deployed.description,
            SubnetIds=self.__ec2_helper.get_subnet_id_list(subnets)
        )

    def add_tags(self, resource_arn, tags):
        return self.rds_client.add_tags_to_resource(
            ResourceName=resource_arn,
            Tags=RDSHelper.get_tags(tags)
        )

    def delete_tags(self, resource_arn, tag_keys):
        return self.rds_client.remove_tags_from_resource(
            ResourceName=resource_arn,
            TagKeys=tag_keys
        )

    def set_output_arn_property(self, response):
        self.__deployed.subnetGroupARN = response['DBSubnetGroup']['DBSubnetGroupArn']
