from com.xebialabs.deployit.plugin.api.reflect import Type


class ResourceMapper(object):
    def __init__(self, _type):
        self.type = _type

    def type_supported(self, resource_type):
        if not Type.valueOf(self.type).exists():
            print("Could not create CI for '%s' because '%s' type does not exist. " % (resource_type, self.type) +
                              "Please, include the plugin that adds support to it.")
            return False
        else:
            return True

    def _create_ci(self, id, properties):
        ci = Type.valueOf(self.type).getDescriptor().newInstance(id)
        for property in properties:
            ci.setProperty(property, properties[property])
        return ci
