from rds.subnet_group.helper import RDSSubnetGroupHelper
from rds.subnet_group.utils import RDSSubnetGroupUtils

print "Modifying Subnet Group {0}".format(deployed.subnetGroupName)
sg_helper = RDSSubnetGroupHelper(deployed=deployed, previous_deployed=previousDeployed)
sg_utils = RDSSubnetGroupUtils(deployed=deployed, previous_deployed=previousDeployed)

sg_helper.modify(deployed.subnets)

tags_to_delete = sg_utils.get_tags_to_be_deleted()
tags_to_add = sg_utils.get_tags_to_be_added()

if bool(tags_to_delete):
    print 'Removing tags {0} from Subnet Group {1}'.format(tags_to_delete, previousDeployed.subnetGroupName)
    sg_helper.delete_tags(resource_arn=deployed.subnetGroupARN, tag_keys=tags_to_delete.keys())

if bool(tags_to_add):
    print 'Adding tags {0} for Subnet Group {1}'.format(tags_to_add, deployed.subnetGroupName)
    sg_helper.add_tags(resource_arn=deployed.subnetGroupARN, tags=tags_to_add)
