from ecs.runnable.service.planningScripts import ci_changed

if deployed.desiredCount == 0 :
    raise RuntimeError('desiredCount value cannot be zero')

if not ci_changed(previousDeployed, deployed):
    context.addStepWithCheckpoint(steps.jython(
        description="Scale service {} to {} instances".format(deployed.serviceName if deployed.serviceName else deployed.name,
                                                              deployed.desiredCount),
        script="ecs/runnable/service/scale_services.py",
        order=81
    ), delta)

    if deployed.waitForTasksNr > 0:
        context.addStepWithCheckpoint(steps.jython(
            description="Wait for service {} on {} to have at least {} task(s) running".format(
                deployed.serviceName if deployed.serviceName else deployed.name, deployed.container.name,
                deployed.waitForTasksNr),
            script="ecs/runnable/service/wait_for_running.py",
            order=82
        ), delta)
else:
    context.addStepWithCheckpoint(steps.jython(
        description="Stop service {} on {}".format(
            previousDeployed.serviceName if previousDeployed.serviceName else previousDeployed.name,
            previousDeployed.container.clusterName),
        script="ecs/runnable/service/stop_service.py",
        order=17
    ), delta)

    context.addStepWithCheckpoint(steps.jython(
        description="Destroy service {} from {}".format(
            previousDeployed.serviceName if previousDeployed.serviceName else previousDeployed.name,
            previousDeployed.container.clusterName),
        script="ecs/runnable/service/delete.py",
        order=18
    ), delta)

    context.addStepWithCheckpoint(steps.jython(
        description="Wait for service {} to fully drain".format(
            previousDeployed.serviceName if previousDeployed.serviceName else previousDeployed.name),
        script="ecs/runnable/service/wait_for_deleted.py",
        order=19
    ), delta)

    context.addStepWithCheckpoint(steps.jython(
        description="Clean up service {} from {}".format(
            previousDeployed.serviceName if previousDeployed.serviceName else previousDeployed.name,
            previousDeployed.container.name),
        script="ecs/runnable/remove.py",
        order=20
    ), delta)

    context.addStepWithCheckpoint(steps.jython(
        description="Prepare service {} on {}".format(deployed.serviceName if deployed.serviceName else deployed.name,
                                                      deployed.container.name),
        script="ecs/runnable/create.py",
        order=80
    ), delta)

    context.addStepWithCheckpoint(steps.jython(
        description="Start service {} on {}".format(deployed.serviceName if deployed.serviceName else deployed.name,
                                                    deployed.container.name),
        script="ecs/runnable/service/create.py",
        order=81
    ), delta)

    if deployed.waitForTasksNr > 0:
        context.addStepWithCheckpoint(steps.jython(
            description="Wait for service {} on {} to have at least {} task(s) running".format(
                deployed.serviceName if deployed.serviceName else deployed.name, deployed.container.name,
                deployed.waitForTasksNr),
            script="ecs/runnable/service/wait_for_running.py",
            order=82
        ), delta)
