#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import yaml
from xld.xlyaml.generic_tag import GenericScalar
from xld.xlyaml.generic_tag import GenericSequence
from xld.xlyaml.generic_tag import GenericMapping


def default_constructor(loader, tag_suffix, node):
    if isinstance(node, yaml.ScalarNode):
        return GenericScalar(node.value, tag_suffix, style=node.style)
    elif isinstance(node, yaml.SequenceNode):
        return GenericSequence(node.value, tag_suffix, flow_style=node.flow_style)
    elif isinstance(node, yaml.MappingNode):
        return GenericMapping(node.value, tag_suffix, flow_style=node.flow_style)
    else:
        raise NotImplementedError(
            'Node type: ' + str(type(node)) + ' | Node: ' + str(node))


def yaml_safe_load(data):
    yaml.add_multi_constructor('', default_constructor, Loader=yaml.SafeLoader)

    return yaml.safe_load(data)
