#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import yaml


class GenericScalar:
    def __init__(self, value, tag, style=None):
        self._value = value
        self._tag = tag
        self._style = style

    @staticmethod
    def to_yaml(dumper, data):
        return dumper.represent_scalar(data._tag, data._value, style=data._style)


class GenericSequence:
    def __init__(self, value, tag, flow_style=None):
        self._value = value
        self._tag = tag
        self._flow_style = flow_style

    @staticmethod
    def to_yaml(dumper, data):
        return dumper.represent_sequence(data._tag, data._value, flow_style=data._flow_style)


class GenericMapping:
    def __init__(self, value, tag, flow_style=None):
        self._value = value
        self._tag = tag
        self._flow_style = flow_style

    @staticmethod
    def to_yaml(dumper, data):
        return dumper.represent_mapping(data._tag, data._value, flow_style=data._flow_style)
