from api.api_helper import APIHelper

api_helper = APIHelper(deployed)

diff = APIHelper.find_diff(previousDeployed, deployed)

context.addStepWithCheckpoint(steps.jython(
    description="Undeploy REST API {0} from {1}".format(APIHelper.get_api_name(deployed=previousDeployed),
                                                        previousDeployed.container.name),
    script="api/steps/undeploy_rest_api.py",
    order=80
), delta)

if diff:
    context.addStepWithCheckpoint(steps.jython(
        description="Modify REST API {0} on {1}".format(APIHelper.get_api_name(deployed=previousDeployed),
                                                        previousDeployed.container.name),
        script="api/steps/modify_rest_api.py",
        order=81
    ), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Destroy resources from REST API {0} on {1}".format(APIHelper.get_api_name(deployed=previousDeployed),
                                                                    deployed.container.name),
    script="api/steps/destroy_resources.py",
    order=82
), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Configure resources in REST API {0} on {1}".format(APIHelper.get_api_name(deployed=previousDeployed),
                                                                    deployed.container.name),
    script="api/steps/configure_resources.py",
    order=83
), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Deploy REST API {0} on {1}".format(APIHelper.get_api_name(deployed=previousDeployed),
                                                    deployed.container.name),
    script="api/steps/deploy_rest_api.py",
    order=84
), delta)
