/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.azure;

import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.AppServicePlans;
import com.microsoft.azure.management.appservice.ConnectionStringType;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebApps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.azure.AzureCredentials;
import com.xebialabs.deployit.plugin.azure.package$;
import java.io.File;
import java.io.Serializable;
import org.python.core.PyList;
import org.python.core.PyObject;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\n\u0014\u0001yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)1\u0007\u0001C\u0001i!9\u0001\b\u0001b\u0001\n\u0013I\u0004BB#\u0001A\u0003%!\bC\u0004G\u0001\t\u0007I\u0011B$\t\r-\u0003\u0001\u0015!\u0003I\u0011\u0015\u0019\u0004\u0001\"\u0001M\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u0011Q\b\u0001\u0005\n\u0005}\u0002bBA&\u0001\u0011%\u0011Q\n\u0005\b\u00037\u0002A\u0011BA/\u000519VMY!qa\u000ec\u0017.\u001a8u\u0015\t!R#A\u0003buV\u0014XM\u0003\u0002\u0017/\u00051\u0001\u000f\\;hS:T!\u0001G\r\u0002\u0011\u0011,\u0007\u000f\\8zSRT!AG\u000e\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u000f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001y\u0002C\u0001\u0011\"\u001b\u0005\u0019\u0012B\u0001\u0012\u0014\u0005A\t%0\u001e:f\u0007J,G-\u001a8uS\u0006d7/A\u0003dY>,H\r\u0005\u0002&U5\taE\u0003\u0002(Q\u0005\u0019Q\u000fZ7\u000b\u0005%*\u0012aA1qS&\u00111F\n\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0017aB2p]R,\u0007\u0010\u001e\t\u0003]Ej\u0011a\f\u0006\u0003a!\nAA\u001a7po&\u0011!g\f\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDcA\u001b7oA\u0011\u0001\u0005\u0001\u0005\u0006G\r\u0001\r\u0001\n\u0005\u0006Y\r\u0001\r!L\u0001\bo\u0016\u0014\u0017\t\u001d9t+\u0005Q\u0004CA\u001eD\u001b\u0005a$BA\u001f?\u0003)\t\u0007\u000f]:feZL7-\u001a\u0006\u0003\u007f\u0001\u000b!\"\\1oC\u001e,W.\u001a8u\u0015\t!\u0012I\u0003\u0002C7\u0005IQ.[2s_N|g\r^\u0005\u0003\tr\u0012qaV3c\u0003B\u00048/\u0001\u0005xK\n\f\u0005\u000f]:!\u0003=\t\u0007\u000f]*feZL7-\u001a)mC:\u001cX#\u0001%\u0011\u0005mJ\u0015B\u0001&=\u0005=\t\u0005\u000f]*feZL7-\u001a)mC:\u001c\u0018\u0001E1qaN+'O^5dKBc\u0017M\\:!)\r)T*\u0017\u0005\u0006\u001d\"\u0001\raT\u0001\baf\u001cEn\\;e!\t\u0001v+D\u0001R\u0015\t\u00116+\u0001\u0003d_J,'B\u0001+V\u0003\u0019\u0001\u0018\u0010\u001e5p]*\ta+A\u0002pe\u001eL!\u0001W)\u0003\u0011AKxJ\u00196fGRDQ\u0001\f\u0005A\u00025\n1aZ3u)\ravL\u001c\t\u0003wuK!A\u0018\u001f\u0003\r]+'-\u00119q\u0011\u0015\u0001\u0017\u00021\u0001b\u0003E\u0011Xm]8ve\u000e,wI]8va:\u000bW.\u001a\t\u0003E.t!aY5\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019l\u0012A\u0002\u001fs_>$hHC\u0001i\u0003\u0015\u00198-\u00197b\u0013\tQw-\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016h\u0011\u0015y\u0017\u00021\u0001b\u0003)9XMY!qa:\u000bW.Z\u0001\u000fGJ,\u0017\r^3PeV\u0003H-\u0019;f)\u0019\u0011ho\u001e={\u007fB\u00111\u000f^\u0007\u0002O&\u0011Qo\u001a\u0002\u0005+:LG\u000fC\u0003p\u0015\u0001\u0007\u0011\rC\u0003a\u0015\u0001\u0007\u0011\rC\u0003z\u0015\u0001\u0007\u0011-\u0001\nbaB\u001cVM\u001d<jG\u0016\u0004F.\u00198OC6,\u0007\"B>\u000b\u0001\u0004a\u0018aC1qaN+G\u000f^5oON\u0004\"\u0001U?\n\u0005y\f&A\u0002)z\u0019&\u001cH\u000f\u0003\u0004\u0002\u0002)\u0001\r\u0001`\u0001\u0012G>tg.Z2uS>t7\u000b\u001e:j]\u001e\u001c\u0018A\u00023fY\u0016$X\rF\u0003s\u0003\u000f\tI\u0001C\u0003a\u0017\u0001\u0007\u0011\rC\u0003p\u0017\u0001\u0007\u0011-\u0001\u0004va2|\u0017\r\u001a\u000b\be\u0006=\u0011\u0011CA\n\u0011\u0015\u0001G\u00021\u0001b\u0011\u0015yG\u00021\u0001b\u0011\u0019\t)\u0002\u0004a\u0001C\u0006!\u0001/\u0019;i\u0003\u0019)\u00070[:ugR1\u00111DA\u0011\u0003G\u00012a]A\u000f\u0013\r\tyb\u001a\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001W\u00021\u0001b\u0011\u0019\t)#\u0004a\u0001C\u0006!a.Y7f\u0003\u0019\u0019'/Z1uKRY!/a\u000b\u0002.\u0005=\u0012\u0011GA\u001a\u0011\u0015yg\u00021\u0001b\u0011\u0015\u0001g\u00021\u0001b\u0011\u0015Yh\u00021\u0001}\u0011\u0019\t\tA\u0004a\u0001y\"9\u0011Q\u0007\bA\u0002\u0005]\u0012AD1qaN+'O^5dKBc\u0017M\u001c\t\u0004w\u0005e\u0012bAA\u001ey\tq\u0011\t\u001d9TKJ4\u0018nY3QY\u0006t\u0017AB;qI\u0006$X\rF\u0006s\u0003\u0003\n\u0019%!\u0012\u0002H\u0005%\u0003\"B8\u0010\u0001\u0004\t\u0007\"\u00021\u0010\u0001\u0004\t\u0007\"B>\u0010\u0001\u0004a\bBBA\u0001\u001f\u0001\u0007A\u0010C\u0004\u00026=\u0001\r!a\u000e\u0002-\u0005\u0004\boU3ui&twm\u001d+p'\u000e\fG.\u0019'jgR$RA]A(\u0003#BQa\u001f\tA\u0002qDq!a\u0015\u0011\u0001\u0004\t)&\u0001\bxSRD\u0017\t\u001d9TKR$\u0018N\\4\u0011\rM\f9&Y1s\u0013\r\tIf\u001a\u0002\n\rVt7\r^5p]J\nAdY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4t)>\u001c6-\u00197b\u0019&\u001cH\u000fF\u0003s\u0003?\n\t\u0007\u0003\u0004\u0002\u0002E\u0001\r\u0001 \u0005\b\u0003G\n\u0002\u0019AA3\u0003Q9\u0018\u000e\u001e5D_:tWm\u0019;j_:\u001cFO]5oOBA1/a\u001abC\u0006-$/C\u0002\u0002j\u001d\u0014\u0011BR;oGRLwN\\\u001a\u0011\u0007m\ni'C\u0002\u0002pq\u0012AcQ8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4UsB,\u0007")
public class WebAppClient
extends AzureCredentials {
    private final WebApps webApps = this.azure().appServices().webApps();
    private final AppServicePlans appServicePlans = this.azure().appServices().appServicePlans();

    private WebApps webApps() {
        return this.webApps;
    }

    private AppServicePlans appServicePlans() {
        return this.appServicePlans;
    }

    public WebApp get(String resourceGroupName, String webAppName) {
        WebApp webApp;
        try {
            webApp = (WebApp)this.webApps().getByResourceGroup(resourceGroupName, webAppName);
        }
        catch (Exception exception) {
            webApp = null;
        }
        return webApp;
    }

    public void createOrUpdate(String webAppName, String resourceGroupName, String appServicePlanName, PyList appSettings, PyList connectionStrings) {
        AppServicePlan servicePlan = (AppServicePlan)this.appServicePlans().getByResourceGroup(resourceGroupName, appServicePlanName);
        if (servicePlan == null) {
            throw new RuntimeException(new StringBuilder(45).append("Service plan ").append(appServicePlanName).append(" not found under Resource group ").append(resourceGroupName).toString());
        }
        if (this.get(resourceGroupName, webAppName) != null) {
            this.update(webAppName, resourceGroupName, appSettings, connectionStrings, servicePlan);
        } else {
            this.create(webAppName, resourceGroupName, appSettings, connectionStrings, servicePlan);
        }
    }

    public void delete(String resourceGroupName, String webAppName) {
        this.webApps().deleteByResourceGroup(resourceGroupName, webAppName);
        this.logOutput(new StringBuilder(42).append("Web App '").append(webAppName).append("' deleted from Resource Group '").append(resourceGroupName).append("'.").toString());
    }

    public void upload(String resourceGroupName, String webAppName, String path) {
        WebApp webApp = (WebApp)this.webApps().getByResourceGroup(resourceGroupName, webAppName);
        File file = new File(path);
        if (file.getName().endsWith(".war")) {
            webApp.warDeploy(file);
            this.logOutput(new StringBuilder(53).append("WAR file deployed to web app '").append(webAppName).append("' on Resource Group '").append(resourceGroupName).append("'.").toString());
        } else {
            webApp.zipDeploy(file);
            this.logOutput(new StringBuilder(53).append("ZIP file deployed to web app '").append(webAppName).append("' on Resource Group '").append(resourceGroupName).append("'.").toString());
        }
    }

    public boolean exists(String resourceGroupName, String name) {
        return this.webApps().getByResourceGroup(resourceGroupName, name) != null;
    }

    private void create(String webAppName, String resourceGroupName, PyList appSettings, PyList connectionStrings, AppServicePlan appServicePlan) {
        WebApp.DefinitionStages.WithWindowsRuntimeStack webApp = ((WebApp.DefinitionStages.Blank)this.webApps().define(webAppName)).withExistingWindowsPlan(appServicePlan).withExistingResourceGroup(resourceGroupName);
        this.appSettingsToScalaList(appSettings, (Function2<String, String, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> {
            webApp.withAppSetting(x$1, x$2);
            return BoxedUnit.UNIT;
        });
        this.connectionStringsToScalaList(connectionStrings, (Function3<String, String, ConnectionStringType, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(x$1, x$2, x$3) -> {
            webApp.withConnectionString(x$1, x$2, x$3);
            return BoxedUnit.UNIT;
        });
        webApp.create();
        this.logOutput(new StringBuilder(40).append("Web App '").append(webAppName).append("' created on Resource Group '").append(resourceGroupName).append("'.").toString());
    }

    private void update(String webAppName, String resourceGroupName, PyList appSettings, PyList connectionStrings, AppServicePlan appServicePlan) {
        WebApp.Update webApp = ((WebApp.UpdateStages.WithAppServicePlan)this.get(resourceGroupName, webAppName).update()).withExistingAppServicePlan(appServicePlan);
        this.appSettingsToScalaList(appSettings, (Function2<String, String, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> {
            webApp.withAppSetting(x$1, x$2);
            return BoxedUnit.UNIT;
        });
        this.connectionStringsToScalaList(connectionStrings, (Function3<String, String, ConnectionStringType, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(x$1, x$2, x$3) -> {
            webApp.withConnectionString(x$1, x$2, x$3);
            return BoxedUnit.UNIT;
        });
        webApp.apply();
        this.logOutput(new StringBuilder(40).append("Web App '").append(webAppName).append("' updated on Resource Group '").append(resourceGroupName).append("'.").toString());
    }

    private void appSettingsToScalaList(PyList appSettings, Function2<String, String, BoxedUnit> withAppSetting) {
        ((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)appSettings).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof PyObject) {
                PyObject pyObject = (PyObject)object2;
                object = withAppSetting.apply((Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "name", package$.MODULE$.getPyObjectStringAttr$default$3()), (Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "value", package$.MODULE$.getPyObjectStringAttr$default$3()));
            } else {
                object = None$.MODULE$;
            }
            return object;
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private void connectionStringsToScalaList(PyList connectionStrings, Function3<String, String, ConnectionStringType, BoxedUnit> withConnectionString) {
        ((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)connectionStrings).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof PyObject) {
                PyObject pyObject = (PyObject)object2;
                object = withConnectionString.apply((Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "name", package$.MODULE$.getPyObjectStringAttr$default$3()), (Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "connection_string", package$.MODULE$.getPyObjectStringAttr$default$3()), (Object)ConnectionStringType.fromString((String)package$.MODULE$.getPyObjectStringAttr(pyObject, "type", package$.MODULE$.getPyObjectStringAttr$default$3())));
            } else {
                object = None$.MODULE$;
            }
            return object;
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public WebAppClient(ConfigurationItem cloud, ExecutionContext context) {
        super(cloud, context);
    }

    public WebAppClient(PyObject pyCloud, ExecutionContext context) {
        this(package$.MODULE$.getAzureCloudFromPyObject(pyCloud), context);
    }
}

