/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.azure;

import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.AppServicePlans;
import com.microsoft.azure.management.appservice.ConnectionStringType;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebApps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.azure.AzureCredentials;
import com.xebialabs.deployit.plugin.azure.package$;
import java.io.File;
import java.io.Serializable;
import org.python.core.PyList;
import org.python.core.PyObject;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001B\t\u0013\u0001uA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)!\u0007\u0001C\u0001g!9q\u0007\u0001b\u0001\n\u0013A\u0004B\u0002#\u0001A\u0003%\u0011\bC\u0004F\u0001\t\u0007I\u0011\u0002$\t\r)\u0003\u0001\u0015!\u0003H\u0011\u0015\u0011\u0004\u0001\"\u0001L\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA\"\u0001\u0011%\u0011Q\t\u0002\r/\u0016\u0014\u0017\t\u001d9DY&,g\u000e\u001e\u0006\u0003'Q\tQ!\u0019>ve\u0016T!!\u0006\f\u0002\rAdWoZ5o\u0015\t9\u0002$\u0001\u0005eKBdw._5u\u0015\tI\"$A\u0005yK\nL\u0017\r\\1cg*\t1$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001=A\u0011q\u0004I\u0007\u0002%%\u0011\u0011E\u0005\u0002\u0011\u0003j,(/Z\"sK\u0012,g\u000e^5bYN\fQa\u00197pk\u0012\u0004\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u0007U$WN\u0003\u0002))\u0005\u0019\u0011\r]5\n\u0005)*#!E\"p]\u001aLw-\u001e:bi&|g.\u0013;f[\u000691m\u001c8uKb$\bCA\u00171\u001b\u0005q#BA\u0018(\u0003\u00111Gn\\<\n\u0005Er#\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019A'\u000e\u001c\u0011\u0005}\u0001\u0001\"\u0002\u0012\u0004\u0001\u0004\u0019\u0003\"B\u0016\u0004\u0001\u0004a\u0013aB<fE\u0006\u0003\bo]\u000b\u0002sA\u0011!HQ\u0007\u0002w)\u0011A(P\u0001\u000bCB\u00048/\u001a:wS\u000e,'B\u0001 @\u0003)i\u0017M\\1hK6,g\u000e\u001e\u0006\u0003'\u0001S!!\u0011\u000e\u0002\u00135L7M]8t_\u001a$\u0018BA\"<\u0005\u001d9VMY!qaN\f\u0001b^3c\u0003B\u00048\u000fI\u0001\u0010CB\u00048+\u001a:wS\u000e,\u0007\u000b\\1ogV\tq\t\u0005\u0002;\u0011&\u0011\u0011j\u000f\u0002\u0010\u0003B\u00048+\u001a:wS\u000e,\u0007\u000b\\1og\u0006\u0001\u0012\r\u001d9TKJ4\u0018nY3QY\u0006t7\u000f\t\u000b\u0004i1C\u0006\"B'\t\u0001\u0004q\u0015a\u00029z\u00072|W\u000f\u001a\t\u0003\u001fZk\u0011\u0001\u0015\u0006\u0003#J\u000bAaY8sK*\u00111\u000bV\u0001\u0007af$\bn\u001c8\u000b\u0003U\u000b1a\u001c:h\u0013\t9\u0006K\u0001\u0005Qs>\u0013'.Z2u\u0011\u0015Y\u0003\u00021\u0001-\u0003\r9W\r\u001e\u000b\u00047zk\u0007C\u0001\u001e]\u0013\ti6H\u0001\u0004XK\n\f\u0005\u000f\u001d\u0005\u0006?&\u0001\r\u0001Y\u0001\u0012e\u0016\u001cx.\u001e:dK\u001e\u0013x.\u001e9OC6,\u0007CA1k\u001d\t\u0011\u0007\u000e\u0005\u0002dM6\tAM\u0003\u0002f9\u00051AH]8pizR\u0011aZ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u001a\fa\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011N\u001a\u0005\u0006]&\u0001\r\u0001Y\u0001\u000bo\u0016\u0014\u0017\t\u001d9OC6,\u0017AD2sK\u0006$Xm\u0014:Va\u0012\fG/\u001a\u000b\tcV4x/\u001f@\u0002\u0002A\u0011!o]\u0007\u0002M&\u0011AO\u001a\u0002\u0005+:LG\u000fC\u0003o\u0015\u0001\u0007\u0001\rC\u0003`\u0015\u0001\u0007\u0001\rC\u0003y\u0015\u0001\u0007\u0001-\u0001\nbaB\u001cVM\u001d<jG\u0016\u0004F.\u00198OC6,\u0007\"\u0002>\u000b\u0001\u0004Y\u0018aC1qaN+G\u000f^5oON\u0004\"a\u0014?\n\u0005u\u0004&A\u0002)z\u0019&\u001cH\u000fC\u0003\u0000\u0015\u0001\u000710A\u0004baB$\u0016mZ:\t\r\u0005\r!\u00021\u0001|\u0003E\u0019wN\u001c8fGRLwN\\*ue&twm]\u0001\u0007I\u0016dW\r^3\u0015\u000bE\fI!a\u0003\t\u000b}[\u0001\u0019\u00011\t\u000b9\\\u0001\u0019\u00011\u0002\rU\u0004Hn\\1e)\u001d\t\u0018\u0011CA\n\u0003+AQa\u0018\u0007A\u0002\u0001DQA\u001c\u0007A\u0002\u0001Da!a\u0006\r\u0001\u0004\u0001\u0017\u0001\u00029bi\"\fa!\u001a=jgR\u001cHCBA\u000f\u0003G\t)\u0003E\u0002s\u0003?I1!!\tg\u0005\u001d\u0011un\u001c7fC:DQaX\u0007A\u0002\u0001Da!a\n\u000e\u0001\u0004\u0001\u0017\u0001\u00028b[\u0016\fa#\u00199q'\u0016$H/\u001b8hgR{7kY1mC2K7\u000f\u001e\u000b\u0006c\u00065\u0012q\u0006\u0005\u0006u:\u0001\ra\u001f\u0005\b\u0003cq\u0001\u0019AA\u001a\u000399\u0018\u000e\u001e5BaB\u001cV\r\u001e;j]\u001e\u0004bA]A\u001bA\u0002\f\u0018bAA\u001cM\nIa)\u001e8di&|gNM\u0001\u0013CB\u0004H+Y4t)>\u001c6-\u00197b\u0019&\u001cH\u000fF\u0003r\u0003{\ty\u0004C\u0003\u0000\u001f\u0001\u00071\u0010C\u0004\u0002B=\u0001\r!a\r\u0002\u000f]LG\u000f\u001b+bO\u0006a2m\u001c8oK\u000e$\u0018n\u001c8TiJLgnZ:U_N\u001b\u0017\r\\1MSN$H#B9\u0002H\u0005%\u0003BBA\u0002!\u0001\u00071\u0010C\u0004\u0002LA\u0001\r!!\u0014\u0002)]LG\u000f[\"p]:,7\r^5p]N#(/\u001b8h!!\u0011\u0018q\n1a\u0003'\n\u0018bAA)M\nIa)\u001e8di&|gn\r\t\u0004u\u0005U\u0013bAA,w\t!2i\u001c8oK\u000e$\u0018n\u001c8TiJLgn\u001a+za\u0016\u0004")
public class WebAppClient
extends AzureCredentials {
    private final WebApps webApps = this.azure().appServices().webApps();
    private final AppServicePlans appServicePlans = this.azure().appServices().appServicePlans();

    private WebApps webApps() {
        return this.webApps;
    }

    private AppServicePlans appServicePlans() {
        return this.appServicePlans;
    }

    public WebApp get(String resourceGroupName, String webAppName) {
        WebApp webApp;
        try {
            webApp = (WebApp)this.webApps().getByResourceGroup(resourceGroupName, webAppName);
        }
        catch (Exception exception) {
            webApp = null;
        }
        return webApp;
    }

    public void createOrUpdate(String webAppName, String resourceGroupName, String appServicePlanName, PyList appSettings, PyList appTags, PyList connectionStrings) {
        AppServicePlan servicePlan = (AppServicePlan)this.appServicePlans().getByResourceGroup(resourceGroupName, appServicePlanName);
        if (servicePlan == null) {
            throw new RuntimeException(new StringBuilder(45).append("Service plan ").append(appServicePlanName).append(" not found under Resource group ").append(resourceGroupName).toString());
        }
        String operation = "";
        operation = this.get(resourceGroupName, webAppName) != null ? "updated" : "created";
        WebApp.DefinitionStages.WithWindowsRuntimeStack webApp = ((WebApp.DefinitionStages.Blank)this.webApps().define(webAppName)).withExistingWindowsPlan(servicePlan).withExistingResourceGroup(resourceGroupName);
        this.appSettingsToScalaList(appSettings, (Function2<String, String, BoxedUnit>)(Function2 & Serializable)(x$1, x$2) -> {
            webApp.withAppSetting(x$1, x$2);
            return BoxedUnit.UNIT;
        });
        this.appTagsToScalaList(appTags, (Function2<String, String, BoxedUnit>)(Function2 & Serializable)(x$1, x$2) -> {
            webApp.withTag(x$1, x$2);
            return BoxedUnit.UNIT;
        });
        this.connectionStringsToScalaList(connectionStrings, (Function3<String, String, ConnectionStringType, BoxedUnit>)(Function3 & Serializable)(x$1, x$2, x$3) -> {
            webApp.withConnectionString(x$1, x$2, x$3);
            return BoxedUnit.UNIT;
        });
        webApp.create();
        this.logOutput(new StringBuilder(33).append("Web App '").append(webAppName).append("' ").append(operation).append(" on Resource Group '").append(resourceGroupName).append("'.").toString());
    }

    public void delete(String resourceGroupName, String webAppName) {
        this.webApps().deleteByResourceGroup(resourceGroupName, webAppName);
        this.logOutput(new StringBuilder(42).append("Web App '").append(webAppName).append("' deleted from Resource Group '").append(resourceGroupName).append("'.").toString());
    }

    public void upload(String resourceGroupName, String webAppName, String path) {
        WebApp webApp = (WebApp)this.webApps().getByResourceGroup(resourceGroupName, webAppName);
        File file = new File(path);
        if (file.getName().endsWith(".war")) {
            webApp.warDeploy(file);
            this.logOutput(new StringBuilder(53).append("WAR file deployed to web app '").append(webAppName).append("' on Resource Group '").append(resourceGroupName).append("'.").toString());
        } else {
            webApp.zipDeploy(file);
            this.logOutput(new StringBuilder(53).append("ZIP file deployed to web app '").append(webAppName).append("' on Resource Group '").append(resourceGroupName).append("'.").toString());
        }
    }

    public boolean exists(String resourceGroupName, String name) {
        return this.webApps().getByResourceGroup(resourceGroupName, name) != null;
    }

    private void appSettingsToScalaList(PyList appSettings, Function2<String, String, BoxedUnit> withAppSetting) {
        appSettings.stream().map(x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof PyObject) {
                PyObject pyObject = (PyObject)object2;
                object = withAppSetting.apply((Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "name", package$.MODULE$.getPyObjectStringAttr$default$3()), (Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "value", package$.MODULE$.getPyObjectStringAttr$default$3()));
            } else {
                object = None$.MODULE$;
            }
            return object;
        });
    }

    private void appTagsToScalaList(PyList appTags, Function2<String, String, BoxedUnit> withTag) {
        appTags.stream().map(x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof PyObject) {
                PyObject pyObject = (PyObject)object2;
                object = withTag.apply((Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "name", package$.MODULE$.getPyObjectStringAttr$default$3()), (Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "value", package$.MODULE$.getPyObjectStringAttr$default$3()));
            } else {
                object = None$.MODULE$;
            }
            return object;
        });
    }

    private void connectionStringsToScalaList(PyList connectionStrings, Function3<String, String, ConnectionStringType, BoxedUnit> withConnectionString) {
        connectionStrings.stream().map(x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof PyObject) {
                PyObject pyObject = (PyObject)object2;
                object = withConnectionString.apply((Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "name", package$.MODULE$.getPyObjectStringAttr$default$3()), (Object)package$.MODULE$.getPyObjectStringAttr(pyObject, "connection_string", package$.MODULE$.getPyObjectStringAttr$default$3()), (Object)ConnectionStringType.fromString((String)package$.MODULE$.getPyObjectStringAttr(pyObject, "type", package$.MODULE$.getPyObjectStringAttr$default$3())));
            } else {
                object = None$.MODULE$;
            }
            return object;
        });
    }

    public WebAppClient(ConfigurationItem cloud, ExecutionContext context) {
        super(cloud, context);
    }

    public WebAppClient(PyObject pyCloud, ExecutionContext context) {
        this(package$.MODULE$.getAzureCloudFromPyObject(pyCloud), context);
    }
}

