from xld.azure import wait_for_success_provisioning

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)

compute_client = connector.compute_client()

resource_group_name = rg.resourceGroupName or rg.name
virtual_machine_name = deployed.virtualMachineName or deployed.name

# synchronous
virtual_machine = compute_client.virtual_machines.get(
    resource_group_name=resource_group_name,
    vm_name=virtual_machine_name,
    expand='instanceview'
)

network_interface_name = virtual_machine.network_profile.network_interfaces[0].id.split('/')[-1]
network_client = connector.network_client()
network_interface = network_client.network_interfaces.get(
    resource_group_name=resource_group_name,
    network_interface_name=network_interface_name
)
print "Private IP: {0}".format(network_interface.ip_configurations[0].private_ip_address)
deployed.privateIp = network_interface.ip_configurations[0].private_ip_address

if network_interface.ip_configurations[0].public_ip_address:
    public_ip_address_name = network_interface.ip_configurations[0].public_ip_address.id.split('/')[-1]
    public_ip_address = network_client.public_ip_addresses.get(
        resource_group_name=resource_group_name,
        public_ip_address_name=public_ip_address_name
    )
    print "Public IP: {0}".format(public_ip_address.ip_address)
    deployed.publicIp = public_ip_address.ip_address
    print "PublicIPName: {0}".format(public_ip_address.name)
    deployed.publicIpName = public_ip_address.name

elif network_interface.ip_configurations[0].load_balancer_backend_address_pools:
    load_balancer_name = network_interface.ip_configurations[0].load_balancer_backend_address_pools[0].id.split('/')[-3]
    print "Load balancer name: {0}".format(load_balancer_name)
    load_balancer = network_client.load_balancers.get(
        resource_group_name=resource_group_name,
        load_balancer_name=load_balancer_name
    )
    public_ip_address_name = load_balancer.frontend_ip_configurations[0].public_ip_address.id.split('/')[-1]
    print "Public IP address name: {0}".format(public_ip_address_name)
    public_ip_address = network_client.public_ip_addresses.get(
        resource_group_name=resource_group_name,
        public_ip_address_name=public_ip_address_name
    )
    print "Public IP: {0}".format(public_ip_address.ip_address)
    deployed.publicIp = public_ip_address.ip_address
    print "PublicIPName: {0}".format(public_ip_address.name)
    deployed.publicIpName = public_ip_address.name
