# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class NetworkFeatures(Resource):
    """Full view of network features for an app (presently VNET integration and
    Hybrid Connections).

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Resource Name.
    :type name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Resource Location.
    :type location: str
    :param type: Resource type.
    :type type: str
    :param tags: Resource tags.
    :type tags: dict
    :ivar virtual_network_name: The Virtual Network name.
    :vartype virtual_network_name: str
    :ivar virtual_network_connection: The Virtual Network summary view.
    :vartype virtual_network_connection: :class:`VnetInfo
     <azure.mgmt.web.models.VnetInfo>`
    :ivar hybrid_connections: The Hybrid Connections summary view.
    :vartype hybrid_connections: list of :class:`RelayServiceConnectionEntity
     <azure.mgmt.web.models.RelayServiceConnectionEntity>`
    :ivar hybrid_connections_v2: The Hybrid Connection V2 (Service Bus) view.
    :vartype hybrid_connections_v2: list of :class:`HybridConnection
     <azure.mgmt.web.models.HybridConnection>`
    """

    _validation = {
        'id': {'readonly': True},
        'location': {'required': True},
        'virtual_network_name': {'readonly': True},
        'virtual_network_connection': {'readonly': True},
        'hybrid_connections': {'readonly': True},
        'hybrid_connections_v2': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'virtual_network_name': {'key': 'properties.virtualNetworkName', 'type': 'str'},
        'virtual_network_connection': {'key': 'properties.virtualNetworkConnection', 'type': 'VnetInfo'},
        'hybrid_connections': {'key': 'properties.hybridConnections', 'type': '[RelayServiceConnectionEntity]'},
        'hybrid_connections_v2': {'key': 'properties.hybridConnectionsV2', 'type': '[HybridConnection]'},
    }

    def __init__(self, location, name=None, kind=None, type=None, tags=None):
        super(NetworkFeatures, self).__init__(name=name, kind=kind, location=location, type=type, tags=tags)
        self.virtual_network_name = None
        self.virtual_network_connection = None
        self.hybrid_connections = None
        self.hybrid_connections_v2 = None
