from xld.azure.connector import AzureConnector

rg = previousDeployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

function_app_name = previousDeployed.appName or previousDeployed.name
resource_group_name = rg.resourceGroupName or rg.name

print "Deleting Function App {0} under Resource Group {1}".format(function_app_name, resource_group_name)

# synchronous
op_result = web_client.web_apps.delete(
    resource_group_name=resource_group_name,
    name=function_app_name,
    raw=True
)

logger.info("Result: {0}".format(op_result))

print "Deleting App Service Plan {0} under Resource Group {1}".format(previousDeployed.servicePlanName, resource_group_name)

# synchronous
op_result = web_client.app_service_plans.delete(
    resource_group_name=resource_group_name,
    name=previousDeployed.servicePlanName,
    raw=True
)

logger.info("Result: {0}".format(op_result))
