/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.azure;

import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.AppServicePlans;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.PricingTier;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.azure.AzureCredentials;
import com.xebialabs.deployit.plugin.azure.package$;
import org.python.core.PyObject;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001B\b\u0011\u0001mA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!)\u0001\u0007\u0001C\u0001c!9Q\u0007\u0001b\u0001\n\u00131\u0004B\u0002\"\u0001A\u0003%q\u0007C\u00031\u0001\u0011\u00051\tC\u0003R\u0001\u0011\u0005!\u000bC\u0003z\u0001\u0011\u0005!\u0010C\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003+\u0002A\u0011AA,\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\u0012A#\u00119q'\u0016\u0014h/[2f!2\fgn\u00117jK:$(BA\t\u0013\u0003\u0015\t'0\u001e:f\u0015\t\u0019B#\u0001\u0004qYV<\u0017N\u001c\u0006\u0003+Y\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003/a\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003e\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uqR\"\u0001\t\n\u0005}\u0001\"\u0001E!{kJ,7I]3eK:$\u0018.\u00197t\u0003\u0015\u0019Gn\\;e!\t\u0011s%D\u0001$\u0015\t!S%A\u0002vI6T!A\n\n\u0002\u0007\u0005\u0004\u0018.\u0003\u0002)G\t\t2i\u001c8gS\u001e,(/\u0019;j_:LE/Z7\u0002\u000f\r|g\u000e^3yiB\u00111FL\u0007\u0002Y)\u0011Q&J\u0001\u0005M2|w/\u0003\u00020Y\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\u001aD\u0007\u0005\u0002\u001e\u0001!)\u0001e\u0001a\u0001C!)\u0011f\u0001a\u0001U\u0005y\u0011\r\u001d9TKJ4\u0018nY3QY\u0006t7/F\u00018!\tA\u0004)D\u0001:\u0015\tQ4(\u0001\u0004n_\u0012,Gn\u001d\u0006\u0003yu\n!\"\u00199qg\u0016\u0014h/[2f\u0015\tqt(A\bsKN|WO]2f[\u0006t\u0017mZ3s\u0015\t\t\u0002$\u0003\u0002Bs\ty\u0011\t\u001d9TKJ4\u0018nY3QY\u0006t7/\u0001\tbaB\u001cVM\u001d<jG\u0016\u0004F.\u00198tAQ\u0019!\u0007\u0012)\t\u000b\u00153\u0001\u0019\u0001$\u0002\u000fAL8\t\\8vIB\u0011qIT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0005G>\u0014XM\u0003\u0002L\u0019\u00061\u0001/\u001f;i_:T\u0011!T\u0001\u0004_J<\u0017BA(I\u0005!\u0001\u0016p\u00142kK\u000e$\b\"B\u0015\u0007\u0001\u0004Q\u0013AB2sK\u0006$X\rF\u0004T3\u001aD'n\u001c;\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\tUs\u0017\u000e\u001e\u0005\u00065\u001e\u0001\raW\u0001\u0005]\u0006lW\r\u0005\u0002]G:\u0011Q,\u0019\t\u0003=Vk\u0011a\u0018\u0006\u0003Aj\ta\u0001\u0010:p_Rt\u0014B\u00012V\u0003\u0019\u0001&/\u001a3fM&\u0011A-\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t,\u0006\"B4\b\u0001\u0004Y\u0016!\u0005:fg>,(oY3He>,\bOT1nK\")\u0011n\u0002a\u00017\u00061!/Z4j_:DQa[\u0004A\u00021\f1\u0002\u001d:jG&tw\rV5feB\u0011\u0001(\\\u0005\u0003]f\u00121\u0002\u0015:jG&tw\rV5fe\")\u0001o\u0002a\u0001c\u0006\u0011qn\u001d\t\u0003qIL!a]\u001d\u0003\u001f=\u0003XM]1uS:<7+_:uK6DQ!^\u0004A\u0002Y\f\u0001bY1qC\u000eLG/\u001f\t\u0003)^L!\u0001_+\u0003\u0007%sG/\u0001\u0004va\u0012\fG/\u001a\u000b\t'ndXP`@\u0002\u0002!)!\f\u0003a\u00017\")q\r\u0003a\u00017\")\u0011\u000e\u0003a\u00017\")1\u000e\u0003a\u0001Y\")\u0001\u000f\u0003a\u0001c\")Q\u000f\u0003a\u0001m\u0006q1M]3bi\u0016|%/\u00169eCR,GcE*\u0002\b\u0005%\u00111BA\u0007\u0003#\t)\"!\u0007\u0002\u001e\u0005\u0005\u0002\"\u0002.\n\u0001\u0004Y\u0006\"B4\n\u0001\u0004Y\u0006\"B5\n\u0001\u0004Y\u0006BBA\b\u0013\u0001\u00071,A\u0004tWVt\u0015-\\3\t\r\u0005M\u0011\u00021\u0001\\\u0003\u001d\u00198.\u001e+jKJDa!a\u0006\n\u0001\u0004Y\u0016aB:lkNK'0\u001a\u0005\u0007\u00037I\u0001\u0019A.\u0002\u0013M\\WOR1nS2L\bBBA\u0010\u0013\u0001\u00071,\u0001\u0004pgRK\b/\u001a\u0005\u0007\u0003GI\u0001\u0019\u0001<\u0002\u0017M\\WoQ1qC\u000eLG/_\u0001\u000fO\u0016$\bK]5dS:<G+[3s)%a\u0017\u0011FA\u0016\u0003[\ty\u0003\u0003\u0004\u0002\u0010)\u0001\ra\u0017\u0005\u0007\u0003'Q\u0001\u0019A.\t\r\u0005]!\u00021\u0001\\\u0011\u0019\tYB\u0003a\u00017\u0006\u0011r-\u001a;Pa\u0016\u0014\u0018\r^5oONK8\u000f^3n)\r\t\u0018Q\u0007\u0005\u0006a.\u0001\raW\u0001\u0005Y&\u001cH\u000f\u0006\u0003\u0002<\u0005M\u0003CBA\u001f\u0003\u0013\ni%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u0011\u0011Xm\u001d;\u000b\t\u0005\u0015\u0013qI\u0001\u0005QR$\bO\u0003\u0002J\u007f%!\u00111JA \u00055\u0001\u0016mZ3e\u0013R,'/\u00192mKB\u0019\u0001(a\u0014\n\u0007\u0005E\u0013H\u0001\bBaB\u001cVM\u001d<jG\u0016\u0004F.\u00198\t\u000b\u001dd\u0001\u0019A.\u0002\r\u0011,G.\u001a;f)\u0015\u0019\u0016\u0011LA.\u0011\u00159W\u00021\u0001\\\u0011\u0015QV\u00021\u0001\\\u0003U9W\r^!qaN+'O^5dKBc\u0017M\u001c(b[\u0016$2aWA1\u0011\u0019\t\u0019G\u0004a\u0001\r\u0006AA-\u001a9m_f,G\r")
public class AppServicePlanClient
extends AzureCredentials {
    private final AppServicePlans appServicePlans = this.azure().appServicePlans();

    private AppServicePlans appServicePlans() {
        return this.appServicePlans;
    }

    public void create(String name, String resourceGroupName, String region, PricingTier pricingTier, OperatingSystem os, int capacity) {
        ((AppServicePlan.DefinitionStages.WithPricingTier)((GroupableResource.DefinitionStages.WithExistingResourceGroup)((Resource.DefinitionWithRegion)this.appServicePlans().define(name)).withRegion(region)).withExistingResourceGroup(resourceGroupName)).withPricingTier(pricingTier).withOperatingSystem(os).withCapacity(capacity).create();
        this.logOutput(new StringBuilder(49).append("App Service Plan '").append(name).append("' created on Resource Group '").append(resourceGroupName).append("'.").toString());
    }

    public void update(String name, String resourceGroupName, String region, PricingTier pricingTier, OperatingSystem os, int capacity) {
        ((AppServicePlan.UpdateStages.WithPricingTier)((Updatable)this.appServicePlans().getByResourceGroup(resourceGroupName, name)).update()).withPricingTier(pricingTier).withCapacity(capacity).apply();
        this.logOutput(new StringBuilder(49).append("App Service Plan '").append(name).append("' updated on Resource Group '").append(resourceGroupName).append("'.").toString());
    }

    public void createOrUpdate(String name, String resourceGroupName, String region, String skuName, String skuTier, String skuSize, String skuFamily, String osType, int skuCapacity) {
        PricingTier pricingTier = this.getPricingTier(skuName, skuTier, skuSize, skuFamily);
        OperatingSystem os = this.getOperatingSystem(osType);
        AppServicePlan appServicePlan = null;
        try {
            appServicePlan = (AppServicePlan)this.appServicePlans().getByResourceGroup(resourceGroupName, name);
        }
        catch (DefaultErrorResponseErrorException x) {
            appServicePlan = null;
        }
        if (appServicePlan != null) {
            this.logOutput(new StringBuilder(48).append("Updating App Service Plan ").append(name).append(" under Resource Group ").append(resourceGroupName).toString());
            this.update(name, resourceGroupName, region, pricingTier, os, skuCapacity);
        } else {
            this.logOutput(new StringBuilder(48).append("Creating App Service Plan ").append(name).append(" under Resource Group ").append(resourceGroupName).toString());
            this.create(name, resourceGroupName, region, pricingTier, os, skuCapacity);
        }
    }

    public PricingTier getPricingTier(String skuName, String skuTier, String skuSize, String skuFamily) {
        String size = skuName != null ? skuName : new StringBuilder(0).append(skuFamily).append(skuSize).toString();
        return new PricingTier(skuTier, size);
    }

    public OperatingSystem getOperatingSystem(String os) {
        return OperatingSystem.fromString((String)os);
    }

    public PagedIterable<AppServicePlan> list(String resourceGroupName) {
        return this.appServicePlans().listByResourceGroup(resourceGroupName);
    }

    public void delete(String resourceGroupName, String name) {
        this.appServicePlans().deleteByResourceGroup(resourceGroupName, name);
        this.logOutput(new StringBuilder(51).append("App Service Plan '").append(name).append("' deleted from Resource Group '").append(resourceGroupName).append("'.").toString());
    }

    private String getAppServicePlanName(PyObject deployed) {
        return package$.MODULE$.getPyObjectStringAttr(deployed, "servicePlanName", package$.MODULE$.getPyObjectStringAttr(deployed, "name", package$.MODULE$.getPyObjectStringAttr$default$3()));
    }

    public AppServicePlanClient(ConfigurationItem cloud, ExecutionContext context) {
        super(cloud, context);
    }

    public AppServicePlanClient(PyObject pyCloud, ExecutionContext context) {
        this(package$.MODULE$.getAzureCloudFromPyObject(pyCloud), context);
    }
}

