# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from enum import Enum


class TransportProtocol(Enum):

    udp = "Udp"
    tcp = "Tcp"


class IPAllocationMethod(Enum):

    static = "Static"
    dynamic = "Dynamic"


class IPVersion(Enum):

    ipv4 = "IPv4"
    ipv6 = "IPv6"


class SecurityRuleProtocol(Enum):

    tcp = "Tcp"
    udp = "Udp"
    asterisk = "*"


class SecurityRuleAccess(Enum):

    allow = "Allow"
    deny = "Deny"


class SecurityRuleDirection(Enum):

    inbound = "Inbound"
    outbound = "Outbound"


class RouteNextHopType(Enum):

    virtual_network_gateway = "VirtualNetworkGateway"
    vnet_local = "VnetLocal"
    internet = "Internet"
    virtual_appliance = "VirtualAppliance"
    none = "None"


class ApplicationGatewayProtocol(Enum):

    http = "Http"
    https = "Https"


class ApplicationGatewayCookieBasedAffinity(Enum):

    enabled = "Enabled"
    disabled = "Disabled"


class ApplicationGatewayBackendHealthServerHealth(Enum):

    unknown = "Unknown"
    up = "Up"
    down = "Down"
    partial = "Partial"
    draining = "Draining"


class ApplicationGatewaySkuName(Enum):

    standard_small = "Standard_Small"
    standard_medium = "Standard_Medium"
    standard_large = "Standard_Large"
    waf_medium = "WAF_Medium"
    waf_large = "WAF_Large"


class ApplicationGatewayTier(Enum):

    standard = "Standard"
    waf = "WAF"


class ApplicationGatewaySslProtocol(Enum):

    tl_sv1_0 = "TLSv1_0"
    tl_sv1_1 = "TLSv1_1"
    tl_sv1_2 = "TLSv1_2"


class ApplicationGatewayRequestRoutingRuleType(Enum):

    basic = "Basic"
    path_based_routing = "PathBasedRouting"


class ApplicationGatewayOperationalState(Enum):

    stopped = "Stopped"
    starting = "Starting"
    running = "Running"
    stopping = "Stopping"


class ApplicationGatewayFirewallMode(Enum):

    detection = "Detection"
    prevention = "Prevention"


class AuthorizationUseStatus(Enum):

    available = "Available"
    in_use = "InUse"


class ExpressRouteCircuitPeeringAdvertisedPublicPrefixState(Enum):

    not_configured = "NotConfigured"
    configuring = "Configuring"
    configured = "Configured"
    validation_needed = "ValidationNeeded"


class Access(Enum):

    allow = "Allow"
    deny = "Deny"


class ExpressRouteCircuitPeeringType(Enum):

    azure_public_peering = "AzurePublicPeering"
    azure_private_peering = "AzurePrivatePeering"
    microsoft_peering = "MicrosoftPeering"


class ExpressRouteCircuitPeeringState(Enum):

    disabled = "Disabled"
    enabled = "Enabled"


class ExpressRouteCircuitSkuTier(Enum):

    standard = "Standard"
    premium = "Premium"


class ExpressRouteCircuitSkuFamily(Enum):

    unlimited_data = "UnlimitedData"
    metered_data = "MeteredData"


class ServiceProviderProvisioningState(Enum):

    not_provisioned = "NotProvisioned"
    provisioning = "Provisioning"
    provisioned = "Provisioned"
    deprovisioning = "Deprovisioning"


class LoadDistribution(Enum):

    default = "Default"
    source_ip = "SourceIP"
    source_ip_protocol = "SourceIPProtocol"


class ProbeProtocol(Enum):

    http = "Http"
    tcp = "Tcp"


class NetworkOperationStatus(Enum):

    in_progress = "InProgress"
    succeeded = "Succeeded"
    failed = "Failed"


class EffectiveRouteSource(Enum):

    unknown = "Unknown"
    user = "User"
    virtual_network_gateway = "VirtualNetworkGateway"
    default = "Default"


class EffectiveRouteState(Enum):

    active = "Active"
    invalid = "Invalid"


class ProvisioningState(Enum):

    succeeded = "Succeeded"
    updating = "Updating"
    deleting = "Deleting"
    failed = "Failed"


class AssociationType(Enum):

    associated = "Associated"
    contains = "Contains"


class Direction(Enum):

    inbound = "Inbound"
    outbound = "Outbound"


class Protocol(Enum):

    tcp = "TCP"
    udp = "UDP"


class NextHopType(Enum):

    internet = "Internet"
    virtual_appliance = "VirtualAppliance"
    virtual_network_gateway = "VirtualNetworkGateway"
    vnet_local = "VnetLocal"
    hyper_net_gateway = "HyperNetGateway"
    none = "None"


class PcProtocol(Enum):

    tcp = "TCP"
    udp = "UDP"
    any = "Any"


class PcStatus(Enum):

    not_started = "NotStarted"
    running = "Running"
    stopped = "Stopped"
    error = "Error"
    unknown = "Unknown"


class PcError(Enum):

    internal_error = "InternalError"
    agent_stopped = "AgentStopped"
    capture_failed = "CaptureFailed"
    local_file_failed = "LocalFileFailed"
    storage_failed = "StorageFailed"


class Origin(Enum):

    local = "Local"
    inbound = "Inbound"
    outbound = "Outbound"


class Severity(Enum):

    error = "Error"
    warning = "Warning"


class IssueType(Enum):

    unknown = "Unknown"
    agent_stopped = "AgentStopped"
    guest_firewall = "GuestFirewall"
    dns_resolution = "DnsResolution"
    socket_bind = "SocketBind"
    network_security_rule = "NetworkSecurityRule"
    user_defined_route = "UserDefinedRoute"
    port_throttled = "PortThrottled"
    platform = "Platform"


class ConnectionStatus(Enum):

    unknown = "Unknown"
    connected = "Connected"
    disconnected = "Disconnected"
    degraded = "Degraded"


class VirtualNetworkPeeringState(Enum):

    initiated = "Initiated"
    connected = "Connected"
    disconnected = "Disconnected"


class VirtualNetworkGatewayType(Enum):

    vpn = "Vpn"
    express_route = "ExpressRoute"


class VpnType(Enum):

    policy_based = "PolicyBased"
    route_based = "RouteBased"


class VirtualNetworkGatewaySkuName(Enum):

    basic = "Basic"
    high_performance = "HighPerformance"
    standard = "Standard"
    ultra_performance = "UltraPerformance"
    vpn_gw1 = "VpnGw1"
    vpn_gw2 = "VpnGw2"
    vpn_gw3 = "VpnGw3"


class VirtualNetworkGatewaySkuTier(Enum):

    basic = "Basic"
    high_performance = "HighPerformance"
    standard = "Standard"
    ultra_performance = "UltraPerformance"
    vpn_gw1 = "VpnGw1"
    vpn_gw2 = "VpnGw2"
    vpn_gw3 = "VpnGw3"


class BgpPeerState(Enum):

    unknown = "Unknown"
    stopped = "Stopped"
    idle = "Idle"
    connecting = "Connecting"
    connected = "Connected"


class ProcessorArchitecture(Enum):

    amd64 = "Amd64"
    x86 = "X86"


class VirtualNetworkGatewayConnectionStatus(Enum):

    unknown = "Unknown"
    connecting = "Connecting"
    connected = "Connected"
    not_connected = "NotConnected"


class VirtualNetworkGatewayConnectionType(Enum):

    ipsec = "IPsec"
    vnet2_vnet = "Vnet2Vnet"
    express_route = "ExpressRoute"
    vpn_client = "VPNClient"


class IpsecEncryption(Enum):

    none = "None"
    des = "DES"
    des3 = "DES3"
    aes128 = "AES128"
    aes192 = "AES192"
    aes256 = "AES256"
    gcmaes128 = "GCMAES128"
    gcmaes192 = "GCMAES192"
    gcmaes256 = "GCMAES256"


class IpsecIntegrity(Enum):

    md5 = "MD5"
    sha1 = "SHA1"
    sha256 = "SHA256"
    gcmaes128 = "GCMAES128"
    gcmaes192 = "GCMAES192"
    gcmaes256 = "GCMAES256"


class IkeEncryption(Enum):

    des = "DES"
    des3 = "DES3"
    aes128 = "AES128"
    aes192 = "AES192"
    aes256 = "AES256"


class IkeIntegrity(Enum):

    md5 = "MD5"
    sha1 = "SHA1"
    sha256 = "SHA256"
    sha384 = "SHA384"


class DhGroup(Enum):

    none = "None"
    dh_group1 = "DHGroup1"
    dh_group2 = "DHGroup2"
    dh_group14 = "DHGroup14"
    dh_group2048 = "DHGroup2048"
    ecp256 = "ECP256"
    ecp384 = "ECP384"
    dh_group24 = "DHGroup24"


class PfsGroup(Enum):

    none = "None"
    pfs1 = "PFS1"
    pfs2 = "PFS2"
    pfs2048 = "PFS2048"
    ecp256 = "ECP256"
    ecp384 = "ECP384"
    pfs24 = "PFS24"
