from xld.azure.arm.helper import TemplateHelper
from com.xebialabs.deployit.plugin.azure import AzureHelper

cf_template = AzureHelper(deployed.container).loadTemplate(deployed.file.path)
if "stitch" in dir():
    cf_template = TemplateHelper(deployed, cf_template, stitch).transform_template()

context.addStep(steps.jython(
    description="Update Resource Group %s on %s" % (deployed.resourceGroupName, deployed.container.name),
    jython_context={"cf_template": cf_template},
    script="xld/azure/arm/update_resources.py",
    preview_script="xld/azure/arm/create_resources_preview.py"
))

context.addStep(steps.jython(
    description="Wait for Resource Group %s to be fully updated" % (deployed.resourceGroupName),
    jython_context={"cf_template": cf_template},
    script="xld/azure/arm/wait_for_ready.py"
))

context.addStep(steps.jython(
    description="Capture output variables from Resource Group %s" % (deployed.resourceGroupName),
    jython_context={"cf_template": cf_template},
    script="xld/azure/arm/capture_output.py"
))
