from azure.mgmt.web.models import AppServicePlan, SkuDescription, Site, SiteConfig, NameValuePair
from xld.azure import get_operation_name

from xld.azure.connector import AzureConnector

rg = deployed.container
app_settings = deployed.appSettings
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()
storage_client = connector.storage_client()

function_app_name = deployed.appName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name

print "{0} App Service Plan {1} under Resource Group {2}".format(
    get_operation_name(previousDeployed),
    deployed.servicePlanName,
    resource_group_name)

op_result = web_client.app_service_plans.create_or_update(
    resource_group_name=resource_group_name,
    name=deployed.servicePlanName,
    app_service_plan=AppServicePlan(
        location=deployed.location,
        sku=SkuDescription(
            name="Y1",
            tier="Dynamic",
            size="1",
            family="Y",
            capacity=0
        )
    ),
    raw=True
)

logger.info("Result: {0}".format(op_result))

print "{0} Function App {1} under Resource Group {2}".format(
    get_operation_name(previousDeployed),
    function_app_name,
    resource_group_name)

storage_keys = storage_client.storage_accounts.list_keys(resource_group_name, deployed.storageAccount)
storage_keys = {v.key_name: v.value for v in storage_keys.keys}
connection_string = "DefaultEndpointsProtocol=https;AccountName=" + deployed.storageAccount + ";AccountKey=" + storage_keys['key1']

function_app_settings = []
for key in ['AzureWebJobsStorage', 'AzureWebJobsDashboard', 'WEBSITE_CONTENTAZUREFILECONNECTIONSTRING']:
    function_app_settings.append(NameValuePair(name=key, value=connection_string))
function_app_settings.append(NameValuePair(name='FUNCTIONS_EXTENSION_VERSION', value='~1'))
function_app_settings.append(NameValuePair(name='WEBSITE_NODE_DEFAULT_VERSION', value='6.5.0'))
function_app_settings.append(NameValuePair(name='WEBSITE_CONTENTSHARE', value=deployed.storageAccount))

for key in app_settings:
    function_app_settings.append(NameValuePair(name=key, value=app_settings[key]))

server_farm_id = "/subscriptions/" + connector.subscription_id + "/resourceGroups/" + resource_group_name + "/providers/Microsoft.Web/serverfarms/" + deployed.servicePlanName

# asynchronous
op_result = web_client.web_apps.create_or_update(
    resource_group_name=resource_group_name,
    name=function_app_name,
    site_envelope=Site(
        location=deployed.location,
        kind="functionapp",
        server_farm_id=server_farm_id,
        site_config=SiteConfig(
            app_settings=function_app_settings
        )
    ),
    raw=True
)

logger.info("Result: {0}".format(op_result))
