import json
from com.xebialabs.deployit.plugin.azure import AzureHelper

azure_helper = AzureHelper(deployed.container)

resourceGroupName = deployed.resourceGroupName

if deployed.createNewResourceGroup:
    print("Creating new Resource Group {0}".format(resourceGroupName))
    if len(deployed.resourceGroupTags) > 0:
        azure_helper.createResourceGroupWithTags(resourceGroupName, deployed.location, deployed.resourceGroupTags)
    else:
        azure_helper.createResourceGroup(resourceGroupName, deployed.location)
else:
    if azure_helper.resourceGroupExists(resourceGroupName):
        print("Found existing resource group {0}".format(resourceGroupName))
    else:
        raise Exception("Resource group with name {0} not found".format(resourceGroupName))

parameters = {}
for k in deployed.inputVariables:
    parameters[k] = {'value': deployed.inputVariables[k]}

azure_helper.deployResourceGroupTemplate(resourceGroupName,
                                         deployed.deploymentName,
                                         cf_template,
                                         json.dumps(parameters),
                                         deployed.deploymentMode)
