from xld.azure.connector import AzureConnector
from azure.mgmt.web.models import SiteConfigResource
from azure.mgmt.web.models.cors_settings import CorsSettings

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

resource_group_name = rg.resourceGroupName or rg.name
function_app_name = deployed.appName or deployed.name

# synchronous
op_result = web_client.web_apps.get(
    resource_group_name=resource_group_name,
    name=function_app_name
)

logger.info("Result: {0}".format(op_result))

if op_result.state != "Running":
    print "Waiting for {0} to be completely created ({1})".format(function_app_name, op_result.state)
    result = "RETRY"
else:
    if deployed.allowedOrigins:
        print "Updating CORS settings ..."

        op_result2 = web_client.web_apps.update_configuration(
            resource_group_name=resource_group_name,
            name=function_app_name,
            site_config=SiteConfigResource(
                location=deployed.location,
                cors=CorsSettings(
                    allowed_origins=deployed.allowedOrigins
                )
            )
        )

        logger.info("Update configuration result: {0}".format(op_result))

    result = "SUCCESS"
