from azure.mgmt.network.models import VirtualNetwork, AddressSpace, DhcpOptions, Subnet
from xld.azure import get_operation_name

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
network_client = connector.network_client()

virtual_network_name = deployed.virtualNetworkName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name

vn_address_space = None

print "AddressSpace {0}".format(deployed.addressPrefixes)

if deployed.addressPrefixes:
    vn_address_space = AddressSpace(
        address_prefixes=deployed.addressPrefixes
    )

vn_dhcp_options = None

print "DhcpOptions {0}".format(deployed.dnsServers)

if deployed.dnsServers:
    vn_dhcp_options = DhcpOptions(
        dns_servers=deployed.dnsServers
    )

vn_subnets = []

print "Subnets {0}".format(deployed.subnets)

for subnet in deployed.subnets:
    subnet_name = subnet.subnetName or subnet.name

    print "Adding {0}".format(subnet)
    current_sg = None
    if subnet.networkSecurityGroupName is not None:
        tmp_network_client = connector.network_client()
        print "Looking up network security group '{0}'".format(subnet.networkSecurityGroupName)
        current_sg = tmp_network_client.network_security_groups.get(
            resource_group_name=resource_group_name,
            network_security_group_name=subnet.networkSecurityGroupName
        )
        print "Network security group details: {0}".format(current_sg)

    current_rt = None
    if subnet.routeTableName is not None:
        print "Looking up route table '{0}'".format(subnet.routeTableName)
        tmp_network_client = connector.network_client()
        current_rt = tmp_network_client.route_tables.get(
            resource_group_name=resource_group_name,
            route_table_name=subnet.routeTableName,
        )
        print "Route table details: {0}".format(current_rt)

    vn_subnets.append(
        Subnet(
            address_prefix=subnet.addressPrefix,
            route_table=current_rt,
            network_security_group=current_sg,
            resource_navigation_links=subnet.resourceNavigationLinks,
            name=subnet_name
        )
    )

network_parameters = VirtualNetwork(
    location=deployed.location,
    tags=deployed.virtualNetworkTags,
    address_space=vn_address_space,
    dhcp_options=vn_dhcp_options,
    subnets=vn_subnets,
    virtual_network_peerings=None
)

print "{0} Virtual Network {1} under Resource Group {2}".format(get_operation_name(previousDeployed),
                                                                virtual_network_name, resource_group_name)

# asynchronous
op_result = network_client.virtual_networks.create_or_update(
    resource_group_name=resource_group_name,
    virtual_network_name=virtual_network_name,
    parameters=network_parameters,
    raw=True
)

logger.info("Result: {0}".format(op_result))
