from azure.mgmt.network.models import NetworkInterface, NetworkInterfaceIPConfiguration
from azure.mgmt.network.models import NetworkInterfaceDnsSettings, SubResource
from xld.azure import string_or_none, object_or_none, boolean_or_none

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
network_client = connector.network_client()

network_interface_name = deployed.networkInterfaceName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name

network_interface_dns_settings = None
if deployed.dnsSettingsEnable:
    print "Creating NetworkInterface DNS settings ..."
    network_interface_dns_settings = NetworkInterfaceDnsSettings(
        dns_servers=deployed.dnsServers,
        applied_dns_servers=deployed.appliedDnsServers,
        internal_dns_name_label=deployed.internalDnsNameLabel,
        internal_fqdn=deployed.internalFqdn,
        internal_domain_name_suffix=deployed.internalDomainNameSuffix
    )

print "Creating NetworkInterface IP configurations ..."
print deployed.ipConfigurations

network_interface_ip_configurations = []

for configuration in deployed.ipConfigurations:

    print "Add NetworkInterface IP configuration"

    ip_configuration_name = configuration.networkInterfaceIPConfigurationName or configuration.name

    network_client2 = connector.network_client()  # temporary workaround
    network_interface_subnet = network_client2.subnets.get(
        resource_group_name,
        configuration.virtualNetworkName,
        configuration.subnet)

    # print network_interface_subnet
    network_interface_public_ip_address = None
    if configuration.publicIpAddress:
        network_client3 = connector.network_client()  # temporary workaround
        network_interface_public_ip_address = network_client3.public_ip_addresses.get(
            resource_group_name=resource_group_name,
            public_ip_address_name=configuration.publicIpAddress
        )
        print "Resolved public ip address to {0}".format(network_interface_public_ip_address)

    backend_address_pools = []

    for backend_address_pool in configuration.backendAddressPools:
        backend_address_pools.append(
            SubResource('/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.Network/loadBalancers/{2}/backendAddressPools/{3}'.format(connector.subscription_id, resource_group_name, backend_address_pool.loadBalancerName, backend_address_pool.LoadBalancerBeAddressPool))
            )

    logger.info("NetworkInterface IP configurations: {0}".format(configuration))

    network_interface_ip_configurations.append(
        NetworkInterfaceIPConfiguration(
            load_balancer_backend_address_pools=backend_address_pools,
            private_ip_address=string_or_none(configuration.privateIpAddress),
            private_ip_allocation_method=string_or_none(configuration.privateIpAllocationMethod),
            private_ip_address_version=string_or_none(configuration.privateIpAddressVersion),
            subnet=object_or_none(network_interface_subnet),
            primary=string_or_none(configuration.primary),
            public_ip_address=object_or_none(network_interface_public_ip_address),
            name=ip_configuration_name
        )
    )

current_sg = None
if deployed.networkSecurityGroupName:
    tmp_network_client = connector.network_client()
    print "Looking up network security group '{0}'".format(deployed.networkSecurityGroupName)
    current_sg = tmp_network_client.network_security_groups.get(
        resource_group_name=resource_group_name,
        network_security_group_name=deployed.networkSecurityGroupName
    )

print "Preparing NetworkInterface parameters ..."
network_interface_parameters = NetworkInterface(
    location=deployed.location,
    tags=deployed.networkInterfaceTags,
    network_security_group=current_sg,
    ip_configurations=object_or_none(network_interface_ip_configurations),
    dns_settings=object_or_none(network_interface_dns_settings),
    mac_address=string_or_none(deployed.macAddress),
    primary=boolean_or_none(deployed.primary),
    enable_ip_forwarding=boolean_or_none(deployed.enableIpForwarding)
)
logger.info("NetworkInterface parameters: {0}".format(network_interface_parameters))

print "Creating NetworkInterface {0} under ResourceGroup {1} ...".format(network_interface_name, resource_group_name)

# TODO CloudError: Azure Error: InvalidRequestFormat
result_create_op = network_client.network_interfaces.create_or_update(
    resource_group_name=resource_group_name,
    network_interface_name=network_interface_name,
    parameters=network_interface_parameters,
    raw=True
)

logger.info("Result: {0}".format(result_create_op))
