/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.profile.AzureProfile;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.UsernamePasswordCredentialBuilder;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.containerservice.ContainerServiceManager;
import com.azure.resourcemanager.containerservice.fluent.ContainerServiceManagementClient;
import com.azure.resourcemanager.containerservice.fluent.ManagedClustersClient;
import com.azure.resourcemanager.containerservice.fluent.models.CredentialResultsInner;
import com.azure.resourcemanager.containerservice.models.CredentialResult;
import com.azure.resourcemanager.monitor.MonitorManager;
import com.azure.resourcemanager.monitor.models.ActivityLogs;
import com.azure.resourcemanager.monitor.models.EventData;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.DeploymentMode;
import com.azure.resourcemanager.resources.models.DeploymentOperation;
import com.azure.resourcemanager.resources.models.Deployments;
import com.azure.resourcemanager.resources.models.GenericResource;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.azure.resourcemanager.resources.models.ResourceGroups;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.azure.package$;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.python.core.PyObject;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tue\u0001B\u001b7\u0001\u0005C\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\u0006'\u0002!\t\u0001\u0016\u0005\b1\u0002\u0011\r\u0011\"\u0001Z\u0011\u0019)\u0007\u0001)A\u00055\"9a\r\u0001b\u0001\n\u0003I\u0006BB4\u0001A\u0003%!\fC\u0004i\u0001\t\u0007I\u0011A-\t\r%\u0004\u0001\u0015!\u0003[\u0011\u001dQ\u0007A1A\u0005\u0002eCaa\u001b\u0001!\u0002\u0013Q\u0006b\u00027\u0001\u0005\u0004%\t!\u0017\u0005\u0007[\u0002\u0001\u000b\u0011\u0002.\t\u000f9\u0004!\u0019!C\u00013\"1q\u000e\u0001Q\u0001\niCq\u0001\u001d\u0001C\u0002\u0013\u0005\u0011\f\u0003\u0004r\u0001\u0001\u0006IA\u0017\u0005\be\u0002\u0011\r\u0011\"\u0001t\u0011\u0019i\b\u0001)A\u0005i\"9a\u0010\u0001a\u0001\n\u0003y\b\"CA\u0007\u0001\u0001\u0007I\u0011AA\b\u0011!\tY\u0002\u0001Q!\n\u0005\u0005\u0001\"CA\u000f\u0001\t\u0007I\u0011AA\u0010\u0011!\t)\u0004\u0001Q\u0001\n\u0005\u0005\u0002\"CA\u001c\u0001\t\u0007I\u0011AA\u001d\u0011!\tY\u0005\u0001Q\u0001\n\u0005m\u0002\u0002C\u001c\u0001\u0005\u0004%\t!!\u0014\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u001fB\u0011\"a\u0016\u0001\u0005\u0004%\t!!\u0017\t\u0011\u0005%\u0004\u0001)A\u0005\u00037B\u0011\"a\u001b\u0001\u0005\u0004%\t!!\u001c\t\u0011\u0005U\u0004\u0001)A\u0005\u0003_B\u0011\"a\u001e\u0001\u0005\u0004%\t!!\u001f\t\u0011\u0005\u001d\u0005\u0001)A\u0005\u0003wB\u0011\"!#\u0001\u0005\u0004%\t!a#\t\u0011\u0005e\u0005\u0001)A\u0005\u0003\u001bCq!a'\u0001\t\u0003\ti\nC\u0004\u0002(\u0002!\t!!+\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007bBAm\u0001\u0011\u0005\u00111\u001c\u0005\b\u0003W\u0004A\u0011AAw\u0011\u001d\t9\u0010\u0001C\u0001\u0003sDq!!@\u0001\t\u0003\ty\u0010C\u0004\u0003\u0014\u0001!\tA!\u0006\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e!9!1\u0005\u0001\u0005\u0002\t\u0015\u0002b\u0002B\u0018\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005k\u0001A\u0011\u0001B\u001c\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0005\u0007BqAa\u0018\u0001\t\u0003\u0011\t\u0007C\u0005\u0003p\u0001\t\n\u0011\"\u0001\u0003r!9!q\u0011\u0001\u0005\u0002\t%%aC!{kJ,\u0007*\u001a7qKJT!a\u000e\u001d\u0002\u000b\u0005TXO]3\u000b\u0005eR\u0014A\u00029mk\u001eLgN\u0003\u0002<y\u0005AA-\u001a9m_fLGO\u0003\u0002>}\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u007f\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\u0007\u0003:L(+\u001a4\u0002\u000b\rdw.\u001e3\u0011\u0005)\u000bV\"A&\u000b\u00051k\u0015\u0001B2pe\u0016T!AT(\u0002\rALH\u000f[8o\u0015\u0005\u0001\u0016aA8sO&\u0011!k\u0013\u0002\t!f|%M[3di\u00061A(\u001b8jiz\"\"!V,\u0011\u0005Y\u0003Q\"\u0001\u001c\t\u000b!\u0013\u0001\u0019A%\u0002\u0015\u0005,H\u000f['fi\"|G-F\u0001[!\tY&M\u0004\u0002]AB\u0011Q\fR\u0007\u0002=*\u0011q\fQ\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005$\u0015A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!\u0019#\u0002\u0017\u0005,H\u000f['fi\"|G\rI\u0001\tG2LWM\u001c;JI\u0006I1\r\\5f]RLE\rI\u0001\ti\u0016t\u0017M\u001c;JI\u0006IA/\u001a8b]RLE\rI\u0001\u000fgV\u00147o\u0019:jaRLwN\\%e\u0003=\u0019XOY:de&\u0004H/[8o\u0013\u0012\u0004\u0013\u0001D2mS\u0016tGoU3de\u0016$\u0018!D2mS\u0016tGoU3de\u0016$\b%\u0001\u0005vg\u0016\u0014h.Y7f\u0003%)8/\u001a:oC6,\u0007%\u0001\u0005qCN\u001cxo\u001c:e\u0003%\u0001\u0018m]:x_J$\u0007%A\u0004qe>4\u0017\u000e\\3\u0016\u0003Q\u0004\"!^>\u000e\u0003YT!A]<\u000b\u0005aL\u0018AC7b]\u0006<W-\\3oi*\u0011AJ\u001f\u0006\u0003oyJ!\u0001 <\u0003\u0019\u0005SXO]3Qe>4\u0017\u000e\\3\u0002\u0011A\u0014xNZ5mK\u0002\n1b\u0019:fI\u0016tG/[1mgV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA=\u0002\u0015\r\u0014X\rZ3oi&\fG.\u0003\u0003\u0002\f\u0005\u0015!a\u0004+pW\u0016t7I]3eK:$\u0018.\u00197\u0002\u001f\r\u0014X\rZ3oi&\fGn]0%KF$B!!\u0005\u0002\u0018A\u00191)a\u0005\n\u0007\u0005UAI\u0001\u0003V]&$\b\"CA\r)\u0005\u0005\t\u0019AA\u0001\u0003\rAH%M\u0001\rGJ,G-\u001a8uS\u0006d7\u000fI\u0001\rC\u000e$\u0018N^5us2{wm]\u000b\u0003\u0003C\u0001B!a\t\u000225\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0004n_\u0012,Gn\u001d\u0006\u0005\u0003W\ti#A\u0004n_:LGo\u001c:\u000b\u0007\u0005=\"0A\bsKN|WO]2f[\u0006t\u0017mZ3s\u0013\u0011\t\u0019$!\n\u0003\u0019\u0005\u001bG/\u001b<jifdunZ:\u0002\u001b\u0005\u001cG/\u001b<jifdunZ:!\u00031\u0019wN\u001c4jOV\u0014\u0018M\u00197f+\t\tY\u0004\u0005\u0003\u0002>\u0005\u0015c\u0002BA \u0003\u0003j!!!\f\n\t\u0005\r\u0013QF\u0001\u0015\u0003j,(/\u001a*fg>,(oY3NC:\fw-\u001a:\n\t\u0005\u001d\u0013\u0011\n\u0002\r\u0007>tg-[4ve\u0006\u0014G.\u001a\u0006\u0005\u0003\u0007\ni#A\u0007d_:4\u0017nZ;sC\ndW\rI\u000b\u0003\u0003\u001f\u0002B!a\u0010\u0002R%!\u00111KA\u0017\u0005Q\t%0\u001e:f%\u0016\u001cx.\u001e:dK6\u000bg.Y4fe\u00061\u0011M_;sK\u0002\n1\u0002Z3qY>LX.\u001a8ugV\u0011\u00111\f\t\u0005\u0003;\n)'\u0004\u0002\u0002`)!\u0011qEA1\u0015\u0011\t\u0019'!\f\u0002\u0013I,7o\\;sG\u0016\u001c\u0018\u0002BA4\u0003?\u00121\u0002R3qY>LX.\u001a8ug\u0006aA-\u001a9m_flWM\u001c;tA\u0005q!/Z:pkJ\u001cWm\u0012:pkB\u001cXCAA8!\u0011\ti&!\u001d\n\t\u0005M\u0014q\f\u0002\u000f%\u0016\u001cx.\u001e:dK\u001e\u0013x.\u001e9t\u0003=\u0011Xm]8ve\u000e,wI]8vaN\u0004\u0013aB7b]\u0006<WM]\u000b\u0003\u0003w\u0002B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000bi#\u0001\td_:$\u0018-\u001b8feN,'O^5dK&!\u0011QQA@\u0005]\u0019uN\u001c;bS:,'oU3sm&\u001cW-T1oC\u001e,'/\u0001\u0005nC:\fw-\u001a:!\u0003=i\u0017M\\1hK\u0012\u001cE.^:uKJ\u001cXCAAG!\u0011\ty)!&\u000e\u0005\u0005E%\u0002BAJ\u0003\u007f\naA\u001a7vK:$\u0018\u0002BAL\u0003#\u0013Q#T1oC\u001e,Gm\u00117vgR,'o]\"mS\u0016tG/\u0001\tnC:\fw-\u001a3DYV\u001cH/\u001a:tA\u0005Qr-\u001a;DYV\u001cH/\u001a:BI6Lgn\u0011:fI\u0016tG/[1mgR)!,a(\u0002$\"1\u0011\u0011\u0015\u0013A\u0002i\u000b\u0011C]3t_V\u00148-Z$s_V\u0004h*Y7f\u0011\u0019\t)\u000b\na\u00015\u0006)2.\u001e2fe:,G/Z:DYV\u001cH/\u001a:OC6,\u0017\u0001\u00067jgR\u0014Vm]8ve\u000e,7OQ=He>,\b\u000f\u0006\u0003\u0002,\u0006\u0005\u0007CBAW\u0003o\u000bY,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003\u0011)H/\u001b7\u000b\u0005\u0005U\u0016\u0001\u00026bm\u0006LA!!/\u00020\nI\u0011I\u001d:bs2K7\u000f\u001e\t\u0005\u0003;\ni,\u0003\u0003\u0002@\u0006}#aD$f]\u0016\u0014\u0018n\u0019*fg>,(oY3\t\r\u0005\u0005V\u00051\u0001[\u0003M\u0011Xm]8ve\u000e,wI]8va\u0016C\u0018n\u001d;t)\u0011\t9-!4\u0011\u0007\r\u000bI-C\u0002\u0002L\u0012\u0013qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\"\u001a\u0002\rAW\u0001\u0014GJ,\u0017\r^3SKN|WO]2f\u000fJ|W\u000f\u001d\u000b\u0007\u0003#\t\u0019.!6\t\r\u0005\u0005v\u00051\u0001[\u0011\u0019\t9n\na\u00015\u00061!/Z4j_:\f1d\u0019:fCR,'+Z:pkJ\u001cWm\u0012:pkB<\u0016\u000e\u001e5UC\u001e\u001cH\u0003CA\t\u0003;\fy.!9\t\r\u0005\u0005\u0006\u00061\u0001[\u0011\u0019\t9\u000e\u000ba\u00015\"9\u00111\u001d\u0015A\u0002\u0005\u0015\u0018\u0001\u0002;bON\u0004b!!,\u0002hjS\u0016\u0002BAu\u0003_\u00131!T1q\u0003A9W\r\u001e*fg>,(oY3He>,\b\u000f\u0006\u0003\u0002p\u0006U\b\u0003BA/\u0003cLA!a=\u0002`\ti!+Z:pkJ\u001cWm\u0012:pkBDa!!)*\u0001\u0004Q\u0016a\u00053fY\u0016$XMU3t_V\u00148-Z$s_V\u0004H\u0003BA\t\u0003wDa!!)+\u0001\u0004Q\u0016a\u00073fa2|\u0017PU3t_V\u00148-Z$s_V\u0004H+Z7qY\u0006$X\r\u0006\u0007\u0002\u0012\t\u0005!1\u0001B\u0004\u0005\u0017\u0011y\u0001\u0003\u0004\u0002\".\u0002\rA\u0017\u0005\u0007\u0005\u000bY\u0003\u0019\u0001.\u0002\u001d\u0011,\u0007\u000f\\8z[\u0016tGOT1nK\"1!\u0011B\u0016A\u0002i\u000bA\u0002^3na2\fG/\u001a&t_:DaA!\u0004,\u0001\u0004Q\u0016A\u00039be\u0006lW\r^3sg\"1!\u0011C\u0016A\u0002i\u000ba\u0002Z3qY>LX.\u001a8u\u001b>$W-\u0001\u0007m_\u0006$G+Z7qY\u0006$X\rF\u0002[\u0005/AaA!\u0007-\u0001\u0004Q\u0016\u0001\u0004;f[Bd\u0017\r^3QCRD\u0017\u0001\u00053fa2|\u00170\\3oi\u0016C\u0018n\u001d;t)\u0019\t9Ma\b\u0003\"!1\u0011\u0011U\u0017A\u0002iCaA!\u0002.\u0001\u0004Q\u0016!H4fi\u001a\u000b\u0017\u000e\\3e\t\u0016\u0004Hn\\=nK:$x\n]3sCRLwN\\:\u0015\t\t\u001d\"Q\u0006\t\u0006\u0003[\u0013ICW\u0005\u0005\u0005W\tyK\u0001\u0003MSN$\bB\u0002B\u0003]\u0001\u0007!,\u0001\nhKR$U\r\u001d7ps6,g\u000e^*uCR,Gc\u0001.\u00034!1!QA\u0018A\u0002i\u000bqcY1qiV\u0014X\rR3qY>LX.\u001a8u\u001fV$\b/\u001e;\u0015\t\te\"q\b\t\u0004\u0007\nm\u0012b\u0001B\u001f\t\n\u0019\u0011I\\=\t\r\t\u0015\u0001\u00071\u0001[\u0003y\u0001(/\u001b8u%\u0016\u001cx.\u001e:dK\u001e\u0013x.\u001e9BGRLg/\u001b;z\u0019><7\u000fF\u0004[\u0005\u000b\u00129Ea\u0013\t\r\u0005\u0005\u0016\u00071\u0001[\u0011\u0019\u0011I%\ra\u00015\u00061A.Y:u\u0013\u0012DqA!\u00142\u0001\u0004\u0011y%A\u0004d_:$X\r\u001f;\u0011\t\tE#1L\u0007\u0003\u0005'RAA!\u0016\u0003X\u0005!a\r\\8x\u0015\r\u0011I\u0006O\u0001\u0004CBL\u0017\u0002\u0002B/\u0005'\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u000f\u001d,G/\u0011;ueR9!La\u0019\u0003h\t-\u0004B\u0002B3e\u0001\u0007\u0011*A\u0002pE*DaA!\u001b3\u0001\u0004Q\u0016\u0001C1uiJt\u0015-\\3\t\u0011\t5$\u0007%AA\u0002i\u000bA\u0002Z3gCVdGOV1mk\u0016\f\u0011cZ3u\u0003R$(\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\u0019HK\u0002[\u0005kZ#Aa\u001e\u0011\t\te$1Q\u0007\u0003\u0005wRAA! \u0003\u0000\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0003#\u0015AC1o]>$\u0018\r^5p]&!!Q\u0011B>\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001$I\u0016dW\r^3SKN|WO]2f\u000fJ|W\u000f\u001d+f[Bd\u0017\r^3SKN|WO]2f)9\t\tBa#\u0003\u000e\nE%Q\u0013BM\u00057Ca!!)5\u0001\u0004Q\u0006B\u0002BHi\u0001\u0007!,A\tqe>4\u0018\u000eZ3s\u001d\u0006lWm\u001d9bG\u0016DaAa%5\u0001\u0004Q\u0016\u0001\u0004:fg>,(oY3UsB,\u0007B\u0002BLi\u0001\u0007!,\u0001\u0007sKN|WO]2f\u001d\u0006lW\r\u0003\u0004\u0003\u0006Q\u0002\rA\u0017\u0005\b\u0005\u001b\"\u0004\u0019\u0001B(\u0001")
public class AzureHelper {
    private final String authMethod;
    private final String clientId;
    private final String tenantId;
    private final String subscriptionId;
    private final String clientSecret;
    private final String username;
    private final String password;
    private final AzureProfile profile;
    private TokenCredential credentials;
    private final ActivityLogs activityLogs;
    private final AzureResourceManager.Configurable configurable;
    private final AzureResourceManager azure;
    private final Deployments deployments;
    private final ResourceGroups resourceGroups;
    private final ContainerServiceManager manager;
    private final ManagedClustersClient managedClusters;

    public String authMethod() {
        return this.authMethod;
    }

    public String clientId() {
        return this.clientId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public AzureProfile profile() {
        return this.profile;
    }

    public TokenCredential credentials() {
        return this.credentials;
    }

    public void credentials_$eq(TokenCredential x$1) {
        this.credentials = x$1;
    }

    public ActivityLogs activityLogs() {
        return this.activityLogs;
    }

    public AzureResourceManager.Configurable configurable() {
        return this.configurable;
    }

    public AzureResourceManager azure() {
        return this.azure;
    }

    public Deployments deployments() {
        return this.deployments;
    }

    public ResourceGroups resourceGroups() {
        return this.resourceGroups;
    }

    public ContainerServiceManager manager() {
        return this.manager;
    }

    public ManagedClustersClient managedClusters() {
        return this.managedClusters;
    }

    public String getClusterAdminCredentials(String resourceGroupName, String kubernetesClusterName) {
        CredentialResultsInner adminCreds = this.managedClusters().listClusterAdminCredentials(resourceGroupName, kubernetesClusterName);
        return new String(((CredentialResult)adminCreds.kubeconfigs().get(0)).value());
    }

    public ArrayList<GenericResource> listResourcesByGroup(String resourceGroupName) {
        ArrayList<GenericResource> list = new ArrayList<GenericResource>();
        Iterator genericResourceItr = this.azure().genericResources().listByResourceGroup(resourceGroupName).iterator();
        while (genericResourceItr.hasNext()) {
            list.add((GenericResource)genericResourceItr.next());
        }
        return list;
    }

    public boolean resourceGroupExists(String resourceGroupName) {
        return this.resourceGroups().contain(resourceGroupName);
    }

    public void createResourceGroup(String resourceGroupName, String region) {
        ((Creatable)((Resource.DefinitionWithRegion)this.resourceGroups().define(resourceGroupName)).withRegion(region)).create();
    }

    public void createResourceGroupWithTags(String resourceGroupName, String region, Map<String, String> tags) {
        ((Creatable)((Resource.DefinitionWithTags)((Resource.DefinitionWithRegion)this.resourceGroups().define(resourceGroupName)).withRegion(region)).withTags(tags)).create();
    }

    public ResourceGroup getResourceGroup(String resourceGroupName) {
        return (ResourceGroup)this.resourceGroups().getByName(resourceGroupName);
    }

    public void deleteResourceGroup(String resourceGroupName) {
        this.resourceGroups().beginDeleteByName(resourceGroupName);
    }

    public void deployResourceGroupTemplate(String resourceGroupName, String deploymentName, String templateJson, String parameters, String deploymentMode) {
        String string = deploymentMode;
        String string2 = "Incremental";
        DeploymentMode mode = !(string != null ? !string.equals(string2) : string2 != null) ? DeploymentMode.INCREMENTAL : DeploymentMode.COMPLETE;
        ((Deployment.DefinitionStages.WithTemplate)((GroupableResource.DefinitionStages.WithExistingResourceGroup)this.deployments().define(deploymentName)).withExistingResourceGroup(resourceGroupName)).withTemplate(templateJson).withParameters(parameters).withMode(mode).beginCreate();
    }

    public String loadTemplate(String templatePath) {
        return new ObjectMapper().readTree((InputStream)new FileInputStream(templatePath)).toPrettyString();
    }

    public boolean deploymentExists(String resourceGroupName, String deploymentName) {
        return this.deployments().checkExistence(resourceGroupName, deploymentName);
    }

    public List<String> getFailedDeploymentOperations(String deploymentName) {
        Deployment deployment = (Deployment)this.deployments().getByName(deploymentName);
        if (deployment != null) {
            Deployment deployment2 = deployment;
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)deployment2.deploymentOperations().list()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AzureHelper.$anonfun$getFailedDeploymentOperations$1(x$1)))).map((Function1 & Serializable)op -> new StringBuilder(4).append(op.statusCode()).append(" : ").append(op.statusMessage()).append(" ").toString())).toList()).asJava();
        }
        return new ArrayList<String>();
    }

    public String getDeploymentState(String deploymentName) {
        Deployment deployment = null;
        for (Deployment deploy : this.deployments().list()) {
            if (!deploy.name().equals(deploymentName)) continue;
            deployment = deploy;
        }
        if (deployment != null) {
            return deployment.provisioningState();
        }
        return null;
    }

    public Object captureDeploymentOutput(String deploymentName) {
        Deployment deployment = null;
        for (Deployment deploy : this.deployments().list()) {
            if (!deploy.name().equals(deploymentName)) continue;
            deployment = deploy;
        }
        if (deployment != null && deployment.outputs() != null) {
            return deployment.outputs();
        }
        return null;
    }

    public String printResourceGroupActivityLogs(String resourceGroupName, String lastId, ExecutionContext context) {
        ListBuffer list = ListBuffer$.MODULE$.empty();
        this.newLogs$1(resourceGroupName, lastId, list);
        ((IterableOnceOps)list.reverse()).foreach((Function1 & Serializable)eventData -> {
            context.logOutput(new StringBuilder(5).append(eventData.eventTimestamp().toString()).append(": ").append(eventData.operationName().localizedValue()).append(" | ").append(eventData.status().localizedValue()).toString());
            return BoxedUnit.UNIT;
        });
        Option option = list.headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            EventData eventData2 = (EventData)some.value();
            return eventData2.id();
        }
        return lastId;
    }

    public String getAttr(PyObject obj, String attrName, String defaultValue) {
        PyObject pyObject;
        PyObject pyObject2 = obj.__findattr__(attrName);
        if (pyObject2 != null && (pyObject = pyObject2).toString() == "None") {
            return defaultValue;
        }
        if (pyObject2 != null) {
            PyObject pyObject3 = pyObject2;
            return pyObject3.toString();
        }
        if (pyObject2 == null) {
            return defaultValue;
        }
        throw new MatchError((Object)pyObject2);
    }

    public String getAttr$default$3() {
        return null;
    }

    public void deleteResourceGroupTemplateResource(String resourceGroupName, String providerNamespace, String resourceType, String resourceName, String deploymentName, ExecutionContext context) {
        context.logOutput(new StringBuilder(34).append("Deleting Resource ").append(resourceName).append("from deployment ").append(deploymentName).toString());
        GenericResource genericResource = this.azure().genericResources().get(resourceGroupName, providerNamespace, resourceType, resourceName);
        this.azure().genericResources().delete(resourceGroupName, genericResource.resourceProviderNamespace(), genericResource.parentResourcePath(), resourceType, resourceName, genericResource.apiVersion());
        context.logOutput(new StringBuilder(32).append("Resource ").append(resourceName).append("from deployment ").append(deploymentName).append("deleted").toString());
    }

    public static final /* synthetic */ boolean $anonfun$getFailedDeploymentOperations$1(DeploymentOperation x$1) {
        return x$1.provisioningState().toLowerCase().equals("failed");
    }

    private final void newLogs$1(String resourceGroupName$1, String lastId$1, ListBuffer list$1) {
        for (EventData eventData : this.activityLogs().defineQuery().startingFrom(OffsetDateTime.now().minusHours(6L)).endsBefore(OffsetDateTime.now()).withAllPropertiesInResponse().filterByResourceGroup(resourceGroupName$1).execute()) {
            if (lastId$1 != null && lastId$1.equals(eventData.id())) {
                return;
            }
            list$1.$plus$eq((Object)eventData);
        }
    }

    public AzureHelper(PyObject cloud) {
        ClientSecretCredential clientSecretCredential;
        this.authMethod = this.getAttr(cloud, "authMethod", this.getAttr$default$3());
        this.clientId = this.getAttr(cloud, "clientId", "04b07795-8ddb-461a-bbee-02f9e1bf7b46");
        this.tenantId = this.getAttr(cloud, "tenantId", this.getAttr$default$3());
        this.subscriptionId = this.getAttr(cloud, "subscriptionId", this.getAttr$default$3());
        this.clientSecret = this.getAttr(cloud, "clientKey", this.getAttr$default$3());
        this.username = this.getAttr(cloud, "userName", this.getAttr$default$3());
        this.password = this.getAttr(cloud, "userPassword", this.getAttr$default$3());
        this.profile = new AzureProfile(this.tenantId(), this.subscriptionId(), AzureEnvironment.AZURE);
        String string = this.authMethod();
        String string2 = package$.MODULE$.DIR_APP_SERVICE_PRINCIPAL_AUTH();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.clientId())).clientSecret(this.clientSecret()).tenantId(this.tenantId()).authorityHost(this.profile().getEnvironment().getActiveDirectoryEndpoint())).build();
        } else {
            String string4 = package$.MODULE$.AD_USER_PASSWORD_AUTH();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                clientSecretCredential = ((UsernamePasswordCredentialBuilder)new UsernamePasswordCredentialBuilder().clientId(this.clientId())).username(this.username()).password(this.password()).build();
            } else {
                throw new Exception(new StringBuilder(38).append("Authentication method '").append(this.authMethod()).append("' not supported").toString());
            }
        }
        this.credentials = clientSecretCredential;
        this.activityLogs = MonitorManager.authenticate((TokenCredential)this.credentials(), (AzureProfile)this.profile()).activityLogs();
        this.configurable = AzureResourceManager.configure();
        this.azure = ((AzureResourceManager.Configurable)this.configurable().withLogLevel(HttpLogDetailLevel.BASIC)).authenticate(this.credentials(), this.profile()).withSubscription(this.subscriptionId());
        this.deployments = this.azure().deployments();
        this.resourceGroups = this.azure().resourceGroups();
        this.manager = ContainerServiceManager.authenticate((TokenCredential)this.credentials(), (AzureProfile)this.profile());
        this.managedClusters = ((ContainerServiceManagementClient)this.manager().serviceClient()).getManagedClusters();
    }
}

