# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AzureFileVolume(Model):
    """The Azure file volume.

    :param share_name: The Azure file share name.
    :type share_name: str
    :param read_only: The flag indicating whether the Azure file volume is
     read only.
    :type read_only: bool
    :param storage_account_name: The storage account name to access to the
     Azure file.
    :type storage_account_name: str
    :param storage_account_key: The storage account key to access to the Azure
     file.
    :type storage_account_key: str
    """

    _validation = {
        'share_name': {'required': True},
        'storage_account_name': {'required': True},
    }

    _attribute_map = {
        'share_name': {'key': 'shareName', 'type': 'str'},
        'read_only': {'key': 'readOnly', 'type': 'bool'},
        'storage_account_name': {'key': 'storageAccountName', 'type': 'str'},
        'storage_account_key': {'key': 'storageAccountKey', 'type': 'str'},
    }

    def __init__(self, share_name, storage_account_name, read_only=None, storage_account_key=None):
        self.share_name = share_name
        self.read_only = read_only
        self.storage_account_name = storage_account_name
        self.storage_account_key = storage_account_key
