from com.xebialabs.deployit.plugin.azure import AzureHelper
import json

azure_helper = AzureHelper(previousDeployed.container)

previous_cf_template = azure_helper.loadTemplate(previousDeployed.file.path)

resourceGroupName = previousDeployed.resourceGroupName
deploymentName = previousDeployed.deploymentName

if previousDeployed.createNewResourceGroup:
    if azure_helper.resourceGroupExists(resourceGroupName):
        azure_helper.deleteResourceGroup(resourceGroupName)
        print("Resource Group '%s' delete initiated" % resourceGroupName)
    else:
        print("Resource Group '%s' does not exist. Ignoring." % resourceGroupName)
else:
    if azure_helper.resourceGroupExists(resourceGroupName):
        print("Deletion of Resources in group '%s' initiated" % resourceGroupName)
        jsonObject = json.loads(previous_cf_template)
        if jsonObject['resources']:
            for resource in jsonObject['resources']:
                if resource['name']:
                    resourceTypeField = resource['type']
                    resourceType = resourceTypeField.split("/",1)[1]
                    providerNamespace = resourceTypeField.split("/",1)[0]
                    azure_helper.deleteResourceGroupTemplateResource(resourceGroupName,
                                                                     providerNamespace,
                                                                     resourceType,
                                                                     resource['name'],
                                                                     deploymentName,context)
        print("Deletion of Resources in group '%s' Completed" % resourceGroupName)
    else:
        print("Resource Group '%s' does not exist. Ignoring." % resourceGroupName)
