/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.azure;

import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.resources.models.GenericResource;
import com.azure.resourcemanager.resources.models.GenericResources;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.azure.resourcemanager.resources.models.ResourceGroups;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.azure.AzureCredentials;
import com.xebialabs.deployit.plugin.azure.package$;
import java.io.Serializable;
import java.util.Map;
import org.python.core.PyNone;
import org.python.core.PyObject;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)Q\u0007\u0001C\u0001m!9!\b\u0001b\u0001\n\u0013Y\u0004BB$\u0001A\u0003%A\bC\u0004I\u0001\t\u0007I\u0011B%\t\r5\u0003\u0001\u0015!\u0003K\u0011\u0015)\u0004\u0001\"\u0001O\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003;\u0001A\u0011AA*\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!!\u0018\u0001\t\u0013\tyFA\nSKN|WO]2f\u000fJ|W\u000f]\"mS\u0016tGO\u0003\u0002\u0017/\u0005)\u0011M_;sK*\u0011\u0001$G\u0001\u0007a2,x-\u001b8\u000b\u0005iY\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005qi\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005q\u0012aA2p[\u000e\u00011C\u0001\u0001\"!\t\u00113%D\u0001\u0016\u0013\t!SC\u0001\tBuV\u0014Xm\u0011:fI\u0016tG/[1mg\u0006)1\r\\8vIB\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\u0004k\u0012l'BA\u0016\u0018\u0003\r\t\u0007/[\u0005\u0003[!\u0012\u0011cQ8oM&<WO]1uS>t\u0017\n^3n\u0003\u001d\u0019wN\u001c;fqR\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0016\u0002\t\u0019dwn^\u0005\u0003iE\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\r9\u0004(\u000f\t\u0003E\u0001AQ!J\u0002A\u0002\u0019BQAL\u0002A\u0002=\naB]3t_V\u00148-Z$s_V\u00048/F\u0001=!\tiT)D\u0001?\u0015\ty\u0004)\u0001\u0004n_\u0012,Gn\u001d\u0006\u0003\u0003\n\u000b\u0011B]3t_V\u00148-Z:\u000b\u0005\r#\u0015a\u0004:fg>,(oY3nC:\fw-\u001a:\u000b\u0005Yi\u0012B\u0001$?\u00059\u0011Vm]8ve\u000e,wI]8vaN\fqB]3t_V\u00148-Z$s_V\u00048\u000fI\u0001\u0011O\u0016tWM]5d%\u0016\u001cx.\u001e:dKN,\u0012A\u0013\t\u0003{-K!\u0001\u0014 \u0003!\u001d+g.\u001a:jGJ+7o\\;sG\u0016\u001c\u0018!E4f]\u0016\u0014\u0018n\u0019*fg>,(oY3tAQ\u0019qgT.\t\u000bAC\u0001\u0019A)\u0002\u000fAL8\t\\8vIB\u0011!+W\u0007\u0002'*\u0011A+V\u0001\u0005G>\u0014XM\u0003\u0002W/\u00061\u0001/\u001f;i_:T\u0011\u0001W\u0001\u0004_J<\u0017B\u0001.T\u0005!\u0001\u0016p\u00142kK\u000e$\b\"\u0002\u0018\t\u0001\u0004y\u0013AB3ySN$8\u000f\u0006\u0002_IB\u0011qLY\u0007\u0002A*\t\u0011-A\u0003tG\u0006d\u0017-\u0003\u0002dA\n9!i\\8mK\u0006t\u0007\"B3\n\u0001\u00041\u0017!\u0005:fg>,(oY3He>,\bOT1nKB\u0011qM\u001c\b\u0003Q2\u0004\"!\u001b1\u000e\u0003)T!a[\u0010\u0002\rq\u0012xn\u001c;?\u0013\ti\u0007-\u0001\u0004Qe\u0016$WMZ\u0005\u0003_B\u0014aa\u0015;sS:<'BA7a\u0003\u0019\u0019'/Z1uKR!1O^<z!\tyF/\u0003\u0002vA\n!QK\\5u\u0011\u0015)'\u00021\u0001g\u0011\u0015A(\u00021\u0001g\u0003\u0019\u0011XmZ5p]\")!P\u0003a\u0001w\u0006!A/Y4t!\u0015a\u00181\u00014g\u001b\u0005i(B\u0001@\u0000\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0005\u0011\u0001\u00026bm\u0006L1!!\u0002~\u0005\ri\u0015\r]\u0001\u0007kB$\u0017\r^3\u0015\u000fM\fY!!\u0004\u0002\u0010!)Qm\u0003a\u0001M\")\u0001p\u0003a\u0001M\")!p\u0003a\u0001w\u0006\u0019q-\u001a;\u0015\t\u0005U\u00111\u0004\t\u0004{\u0005]\u0011bAA\r}\ti!+Z:pkJ\u001cWm\u0012:pkBDQ!\u001a\u0007A\u0002\u0019\fa\u0001Z3mKR,GcA:\u0002\"!)Q-\u0004a\u0001M\u0006)\u0002.Y:EKB,g\u000eZ3oiJ+7o\\;sG\u0016\u001cHc\u00010\u0002(!)QM\u0004a\u0001M\u0006)r-\u001a;EKB,g\u000eZ3oiJ+7o\\;sG\u0016\u001cH\u0003BA\u0017\u0003\u000b\u0002b!a\f\u0002<\u0005}RBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\tI,7\u000f\u001e\u0006\u0005\u0003o\tI$\u0001\u0003iiR\u0004(B\u0001+E\u0013\u0011\ti$!\r\u0003\u001bA\u000bw-\u001a3Ji\u0016\u0014\u0018M\u00197f!\ri\u0014\u0011I\u0005\u0004\u0003\u0007r$aD$f]\u0016\u0014\u0018n\u0019*fg>,(oY3\t\u000b\u0015|\u0001\u0019\u00014\u0002\u001d\r\u0014X-\u0019;f\u001fJ,\u0006\u000fZ1uKR)1/a\u0013\u0002P!1\u0011Q\n\tA\u0002E\u000b\u0001\u0002Z3qY>LX\r\u001a\u0005\u0007\u0003#\u0002\u0002\u0019A)\u0002!A\u0014XM^5pkN$U\r\u001d7ps\u0016$GcA:\u0002V!1\u0011\u0011K\tA\u0002E\u000b\u0001d\u00195fG.$U\r]3oI\u0016tGo]!oI\u0012+G.\u001a;f)\r\u0019\u00181\f\u0005\u0006KJ\u0001\rAZ\u0001\u0015O\u0016$(+Z:pkJ\u001cWm\u0012:pkBt\u0015-\\3\u0015\u0007\u0019\f\t\u0007\u0003\u0004\u0002NM\u0001\r!\u0015")
public class ResourceGroupClient
extends AzureCredentials {
    private final ResourceGroups resourceGroups = this.azure().resourceGroups();
    private final GenericResources genericResources = this.azure().genericResources();

    private ResourceGroups resourceGroups() {
        return this.resourceGroups;
    }

    private GenericResources genericResources() {
        return this.genericResources;
    }

    public boolean exists(String resourceGroupName) {
        return this.resourceGroups().contain(resourceGroupName);
    }

    public void create(String resourceGroupName, String region, Map<String, String> tags) {
        ((Creatable)((Resource.DefinitionWithTags)((Resource.DefinitionWithRegion)this.resourceGroups().define(resourceGroupName)).withRegion(region)).withTags(tags)).create();
        this.logOutput(new StringBuilder(26).append("Resource Group '").append(resourceGroupName).append("' created.").toString());
    }

    public void update(String resourceGroupName, String region, Map<String, String> tags) {
        ((Appliable)((Resource.UpdateWithTags)((Updatable)this.resourceGroups().getByName(resourceGroupName)).update()).withTags(tags)).apply();
        this.logOutput(new StringBuilder(26).append("Resource Group '").append(resourceGroupName).append("' updated.").toString());
    }

    public ResourceGroup get(String resourceGroupName) {
        return (ResourceGroup)this.resourceGroups().getByName(resourceGroupName);
    }

    public void delete(String resourceGroupName) {
        this.logOutput(new StringBuilder(50).append("Deleting Resource Group '").append(resourceGroupName).append("' under SubscriptionId '").append(this.subscriptionId()).append("'").toString());
        this.resourceGroups().beginDeleteByName(resourceGroupName);
    }

    public boolean hasDependentResources(String resourceGroupName) {
        return Iterables.size((Iterable)this.genericResources().listByResourceGroup(resourceGroupName)) > 0;
    }

    public PagedIterable<GenericResource> getDependentResources(String resourceGroupName) {
        return this.genericResources().listByResourceGroup(resourceGroupName);
    }

    public void createOrUpdate(PyObject deployed, PyObject previousDeployed) {
        String resourceGroupName = this.getResourceGroupName(deployed);
        String region = package$.MODULE$.getPyObjectStringAttr(deployed, "location", package$.MODULE$.getPyObjectStringAttr$default$3());
        Map<String, String> tags = package$.MODULE$.getPyObjectMapStringStringAttr(deployed, "resourceGroupTags", package$.MODULE$.getPyObjectMapStringStringAttr$default$3());
        if (previousDeployed == null || previousDeployed instanceof PyNone) {
            this.logOutput(new StringBuilder(50).append("Creating Resource Group '").append(resourceGroupName).append("' under SubscriptionId '").append(this.subscriptionId()).append("'").toString());
            this.create(resourceGroupName, region, tags);
            return;
        }
        String previousRGName = this.getResourceGroupName(previousDeployed);
        Checks.checkArgument((boolean)resourceGroupName.equals(previousRGName), (String)new StringBuilder(61).append("Resource group name is not allowed to change on update (").append(previousRGName).append(" -> ").append(resourceGroupName).append(")").toString(), (Object[])new Object[0]);
        String previousRegion = package$.MODULE$.getPyObjectStringAttr(previousDeployed, "location", package$.MODULE$.getPyObjectStringAttr$default$3());
        Checks.checkArgument((boolean)region.equals(previousRegion), (String)new StringBuilder(51).append("Location is not allowed to change on update (").append(previousRegion).append(" -> ").append(region).append(")!").toString(), (Object[])new Object[0]);
        this.logOutput(new StringBuilder(50).append("Updating Resource Group '").append(resourceGroupName).append("' under SubscriptionId '").append(this.subscriptionId()).append("'").toString());
        this.update(resourceGroupName, region, tags);
    }

    public void delete(PyObject previousDeployed) {
        this.checkDependentsAndDelete(this.getResourceGroupName(previousDeployed));
    }

    public void checkDependentsAndDelete(String resourceGroupName) {
        if (this.exists(resourceGroupName)) {
            PagedIterable<GenericResource> dependentResources = this.getDependentResources(resourceGroupName);
            if (Iterables.size(dependentResources) > 0) {
                String names = ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(dependentResources).asScala().map((Function1 & Serializable)x$1 -> x$1.id())).mkString("  \n");
                throw new RuntimeException(new StringBuilder(43).append("Resource Group '").append(resourceGroupName).append("' has dependent resources:\n").append(names).toString());
            }
            this.delete(resourceGroupName);
            return;
        }
    }

    private String getResourceGroupName(PyObject deployed) {
        return package$.MODULE$.getPyObjectStringAttr(deployed, "resourceGroupName", package$.MODULE$.getPyObjectStringAttr(deployed, "name", package$.MODULE$.getPyObjectStringAttr$default$3()));
    }

    public ResourceGroupClient(ConfigurationItem cloud, ExecutionContext context) {
        super(cloud, context);
    }

    public ResourceGroupClient(PyObject pyCloud, ExecutionContext context) {
        this(package$.MODULE$.getAzureCloudFromPyObject(pyCloud), context);
    }
}

