import requests
from xld.azure.connector import AzureConnector
cloud = previousDeployed.container
connector = AzureConnector(cloud)
subscription_id = previousDeployed.container.subscriptionId
resource_group_name = previousDeployed.resourceGroupName or previousDeployed.name

logger.info("Checking existence of {0} under SubscriptionId {1}".format(resource_group_name, subscription_id))

resource_group_name = previousDeployed.resourceGroupName or previousDeployed.name
url = "https://management.azure.com/subscriptions/{}/resourcegroups/{}?api-version=2021-04-01".format(subscription_id,resource_group_name)
headers = {'Content-Type': 'application/json','Authorization': 'Bearer ' + connector.credentials.token['access_token']}
response = requests.head(url,headers=headers, proxies=connector.proxiesdict)
is_group_present = True
if(response.status_code == 204):
    is_group_present = True
    logger.info("Resource is present: {0}".format(is_group_present))
else:
    is_group_present = False

if is_group_present:
    url = "https://management.azure.com/subscriptions/{}/resourceGroups/{}/resources?api-version=2021-04-01".format(subscription_id,resource_group_name)
    headers = {'Content-Type': 'application/json','Authorization': 'Bearer ' + connector.credentials.token['access_token']}
    getresponse = requests.get(url,headers=headers, proxies=connector.proxiesdict)
    getresponseLoad = getresponse.json()
    size_existing_resources = len(getresponseLoad['value'])
    if size_existing_resources > 0:
        existing_resources = [i['id'] for i in getresponseLoad['value']]
        raise Exception("Group {0} has dependent resources:\n{1}".format(
            resource_group_name, "\n".join(existing_resources)))

print "Deleting Resource Group {0} under SubscriptionId {1}".format(resource_group_name, subscription_id)
url = "https://management.azure.com/subscriptions/{}/resourcegroups/{}?api-version=2021-04-01".format(previousDeployed.container.subscriptionId,resource_group_name)
headers = {'Content-Type': 'application/json','Authorization': 'Bearer ' + connector.credentials.token['access_token']}
response = requests.delete(url, headers=headers, proxies=connector.proxiesdict)
logger.info("Deleted: {0}".format(resource_group_name))
