/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.azure;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.azure.NetworkAddress;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="list-of-azure-network-address")
@ApplicableTo(value={PropertyKind.LIST_OF_STRING})
public @interface NetworkAddresses {
    public static final String DEFAULT_MESSAGE = "Addresses [%s] are not valid";
    public static final boolean DEFAULT_ALLOW_MASK = true;
    public static final boolean DEFAULT_ALLOW_WILDCARD = false;

    public String message() default "Addresses [%s] are not valid";

    public boolean allowMask() default true;

    public boolean allowWildcard() default false;

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<List<String>> {
        private String message = "Addresses [%s] are not valid";
        private boolean allowMask = true;
        private boolean allowWildcard = false;

        public void validate(List<String> addresses, ValidationContext context) {
            if (addresses == null) {
                return;
            }
            ArrayList<String> invalidAddresses = new ArrayList<String>();
            for (String addr : addresses) {
                if (NetworkAddress.Validator.isValidAddress(addr, this.allowMask, this.allowWildcard)) continue;
                invalidAddresses.add(addr);
            }
            if (!invalidAddresses.isEmpty()) {
                context.error(this.message, new Object[]{((Object)invalidAddresses).toString()});
            }
        }
    }
}

