from azure.mgmt.network.models import FrontendIPConfiguration, PublicIPAddress, BackendAddressPool, Probe, LoadBalancingRule, LoadBalancer
from xld.azure import get_operation_name

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
network_client = connector.network_client()

load_balancer_name = deployed.loadBalancerName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name

frontend_ip_configurations = []
backend_address_pools = []
load_balancing_rules = []
probes = []


for frontend_ip_configuration in deployed.frontendIpConfigurations:
    public_ip_address = network_client.public_ip_addresses.get(
        resource_group_name=resource_group_name,
        public_ip_address_name=frontend_ip_configuration.frontendIpName
    )
    frontend_ip_configurations.append(
        FrontendIPConfiguration(
            name = frontend_ip_configuration.frontendIpConfigurationName,
            private_ip_allocation_method = frontend_ip_configuration.privateIpAllocationMethod,
            public_ip_address = public_ip_address
        )
    )
    print "Result: {0}".format(frontend_ip_configurations)


for backend_address_pool in deployed.backendAddressPools:
    backend_address_pools.append(
        BackendAddressPool(
            name = backend_address_pool.backendAddressPoolName
        )
    )
    print "Result: {0}".format(backend_address_pools)


for probe in deployed.loadBalancingProbes:
    probes.append(
        Probe(
        name = probe.loadBalancingProbeName,
        port = probe.loadBalancingProbePort,
        protocol = probe.loadBalancingProbeProtocol,
        request_path = probe.loadBalancingProbePath
        )
    )
    print "Result: {0}".format(probes)


frontend_ip_configuration_id = None
backend_address_pool_id = None
probe_id = None

for load_balancing_rule in deployed.loadBalancingRules:

    for frontend_ip_configuration in frontend_ip_configurations:
        if frontend_ip_configuration.name == load_balancing_rule.loadBalancingRuleFrontendIpConfiguration:
            frontend_ip_configuration_id = { 'id': '/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.Network/loadBalancers/{2}/frontendIPConfigurations/{3}'.format(connector.subscription_id, resource_group_name, load_balancer_name, frontend_ip_configuration.name) }
            print frontend_ip_configuration_id

    for backend_address_pool in backend_address_pools:
        if backend_address_pool.name == load_balancing_rule.loadBalancingRuleBackendAddressPool:
            backend_address_pool_id = { 'id': '/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.Network/loadBalancers/{2}/backendAddressPools/{3}'.format(connector.subscription_id, resource_group_name, load_balancer_name, backend_address_pool.name) }
            print backend_address_pool_id

    for probe in probes:
        if probe.name == load_balancing_rule.loadBalancingProbe:
            probe_id = { 'id': '/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.Network/loadBalancers/{2}/probes/{3}'.format(connector.subscription_id, resource_group_name, load_balancer_name, probe.name) }
            print probe_id

    load_balancing_rules.append(
        LoadBalancingRule(
            name = load_balancing_rule.loadBalancingRuleName,
            protocol = load_balancing_rule.loadBalancingRuleProtocol,
            frontend_port = load_balancing_rule.loadBalancingRuleFrontendPort,
            backend_port = load_balancing_rule.loadBalancingRuleBackendPort,
            idle_timeout_in_minutes = load_balancing_rule.loadBalancingRuleTimeout,
            frontend_ip_configuration = frontend_ip_configuration_id,
            backend_address_pool = backend_address_pool_id,
            probe = probe_id
        )
    )
    print "Result: {0}".format(load_balancing_rules)


load_balancer_parameters = LoadBalancer(
    location = deployed.location,
    frontend_ip_configurations = frontend_ip_configurations,
    backend_address_pools = backend_address_pools,
    load_balancing_rules = load_balancing_rules,
    probes = probes
    )
print "Result: {0}".format(load_balancer_parameters)

op_result = network_client.load_balancers.create_or_update(
    resource_group_name=resource_group_name,
    load_balancer_name=load_balancer_name,
    parameters=load_balancer_parameters,
    raw=True
)

logger.info("Result: {0}".format(op_result))
