from azure.mgmt.web.models import NameValuePair, ConnStringInfo
from xld.azure import get_operation_name
from xld.azure.AzurePythonHelper import AzurePyHelper

from com.xebialabs.deployit.plugin.azure import WebAppClient

import json

rg = deployed.container
cloud = rg.container
azure_helper = AzurePyHelper(cloud)

azure_web_app_client = WebAppClient(cloud, context)

resource_group_name = rg.resourceGroupName or rg.name
web_app_name = deployed.appName or deployed.name

print "{0} Web App {1} under Resource Group {2}".format(
    get_operation_name(previousDeployed),
    web_app_name,
    resource_group_name)

app_settings = []
if deployed.appSettings.keys():
    for key,value in deployed.appSettings.items():
        app_settings.append({'name': key, 'value': value})

app_tags = {}
if deployed.appTags.keys():
    for key,value in deployed.appTags.items():
        app_tags[key] = value

web_app_conn_strings = []
if deployed.sqlDatabaseConnectionStrings.keys() or deployed.sqlServerConnectionStrings.keys() or deployed.customConnectionStrings.keys():
    for key,value in deployed.sqlDatabaseConnectionStrings.items():
            web_app_conn_strings.append({'name': key, 'connectionString': value, 'type': 'SQLAzure'})
    for key,value in deployed.sqlServerConnectionStrings.items():
            web_app_conn_strings.append({'name': key, 'connectionString': value, 'type': 'SQLServer'})
    for key,value in deployed.customConnectionStrings.items():
            web_app_conn_strings.append({'name': key, 'connectionString': value, 'type': 'Custom'})

server_farm_id = "/subscriptions/" + cloud.subscriptionId + "/resourceGroups/" + resource_group_name + "/providers/Microsoft.Web/serverfarms/" + deployed.servicePlanName


body = {
    "location": rg.location,
    "properties": {
        "serverFarmId": server_farm_id,
        "siteConfig": {
            "appSettings": app_settings,
            "connectionStrings": web_app_conn_strings,
            "linuxFxVersion": deployed.linuxFxVersion if deployed.linuxFxVersion else None,
            "windowsFxVersion": deployed.windowsFxVersion if deployed.windowsFxVersion else None,
            "appCommandLine": deployed.appCommandLine if deployed.appCommandLine else None
            }
        },
    "tags": app_tags
}

azure_helper.create_webapp(resource_group_name, web_app_name, json.dumps(body))

print "WebApp created/updated successfully"
