import requests
import json

from xld.azure.connector import AzureConnector

feed = previousDeployed.container
cloud = feed.container
connector = AzureConnector(cloud)

org_url = feed.organizationUrl
project_name = feed.projectName
scope = feed.scope

if org_url.endswith('/'):
    org_url = my_str = org_url[:-1]

org_name = org_url.rsplit('/', 1)[-1]

token = "Bearer " + connector.credentials.token['access_token']

if scope == 'project':
    delete_package = "https://pkgs.dev.azure.com/" + org_name + "/" + project_name + "/_apis/packaging/feeds/" + feed.feedName + "/upack/packages/" + previousDeployed.packageName + "/versions/" + previousDeployed.packageVersion + "?api-version=5.1-preview.1"
else:
    delete_package = "https://pkgs.dev.azure.com/" + org_name + "/_apis/packaging/feeds/" + feed.feedName + "/upack/packages/" + previousDeployed.packageName + "/versions/" + previousDeployed.packageVersion + "?api-version=5.1-preview.1"

headers = {
    "Content-type": "application/json",
    "Authorization": token
}

r = requests.delete(url=delete_package, headers=headers)

print("status_code {0}".format(r.status_code))
print("text {0}".format(r.text))

if r.status_code != 202:
    raise Exception('Delete feed failed')
    return
