import time
import os
import subprocess
from subprocess import Popen, PIPE

cloud = deployed.container

def execute_command(command_group, command):
    process = subprocess.Popen(command, stdout=PIPE, stderr=PIPE, shell=True)
    stdout, stderr = process.communicate()
    return_code = process.returncode

    if return_code != 0:
        error = stderr
        raise Exception("Execution failed for {} with error : {}".format(command_group, error))
    else:
        response_str = stdout
        return return_code

az_login_command = ""

if deployed.container.authMethod == 'active-directory-user-password':
    az_login_command = "az login -u {} -p {}"
    az_login_command = az_login_command.format(deployed.container.userName,deployed.container.userPassword)
else:
    az_login_command = "az login --service-principal -u {} -p {} --tenant {}"
    az_login_command = az_login_command.format(deployed.container.clientId,deployed.container.clientKey,deployed.container.tenantId)
execute_command("az cli login", az_login_command)
print("Executed the CLI Logged in Successfully completed")
time.sleep(5)

# Execute the bicep deploy command.
abs_path = os.path.abspath(deployed.file.path)
deploy_bicep_command = "az deployment group create --resource-group {} --name {} --subscription {} --mode {} --template-file {}"
deploy_bicep_command = deploy_bicep_command.format(deployed.resourceGroupName, deployed.deploymentName, deployed.container.subscriptionId, deployed.deploymentMode, abs_path)
if deployed.inputVariables is not None and len(deployed.inputVariables) > 0:
    deploy_bicep_command = deploy_bicep_command + " --parameters "
    for k in deployed.inputVariables:
        if deployed.inputVariables[k].startswith("{"):
            deploy_bicep_command = deploy_bicep_command+str(k)+"=\""+str(deployed.inputVariables[k])+"\" "
        else:
            deploy_bicep_command = deploy_bicep_command+str(k)+"="+str(deployed.inputVariables[k])+" "

# Sample Command Generated
##  Overall Generated Command : az deployment group create --resource-group Integ-res-group --name newname124 --subscription <SubscriptionId> --mode Complete --template-file <SubscriptionId>
#   --parameters largeFileSharesState=Disabled tags="{'Owner':'Contoso','Cost Center':'2345-324'}"
# Sample Object conversion to Command line - tags="{'Owner':'Contoso','Cost Center':'2345-324'}".

execute_command("az bicep file deployment", deploy_bicep_command)
print("Executed the Bicep Deployment Successfully completed")
time.sleep(5)

# Log out the Az.CLI.
deploy_bicep_command = "az logout"
execute_command("az cli logout", az_login_command)
print("Executed the CLI Logout Successfully completed")

