
if deployed.createNewResourceGroup:
    context.addStep(steps.jython(
        description="Create Resource Group %s on %s" % (deployed.resourceGroupName, deployed.container.name),
        script="xld/azure/resource_group/create-or-update.py"
    ))
    context.addStep(steps.jython(
        description="Wait for Resource Group %s on %s to be created" % (deployed.resourceGroupName, deployed.container.name),
        script="xld/azure/resource_group/create_wait.py"
    ))

context.addStepWithCheckpoint(steps.jython(
    description="Create Resources : Submit template for creation",
    script="xld/azure/bicep/create_or_update_resources_rest.py"
), delta)

context.addStep(steps.jython(
    description="Wait for Resources in %s to be fully created" % (deployed.resourceGroupName),
    script="xld/azure/arm/wait_for_ready_rest.py"
))

context.addStep(steps.jython(
    description="Capture output variables from Resource Group %s" % (deployed.resourceGroupName),
    script="xld/azure/arm/capture_output.py"
))
