from azure.mgmt.network.models import RouteTable, Route
from xld.azure import get_operation_name

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
network_client = connector.network_client()

route_table_name = deployed.routeTableName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name

table_routes = []

for route in deployed.routes:
    route_name = route.routeName or route.name

    route_instance = Route(
        address_prefix=route.addressPrefix,
        next_hop_type=route.nextHopType,
        name=route_name
    )
    if route.nextHopType == "VirtualAppliance":
        route_instance.next_hop_ip_address = route.nextHopIpAddress

    table_routes.append(route_instance)

route_table_params_create = RouteTable(
    location=deployed.location,
    tags=deployed.routeTableTags,
    routes=table_routes,
)

print "{0} Route Table {1} under Resource Group {2}".format(get_operation_name(previousDeployed),
                                                            route_table_name, resource_group_name)

# asynchronous
op_result = network_client.route_tables.create_or_update(
    resource_group_name=resource_group_name,
    route_table_name=route_table_name,
    parameters=route_table_params_create,
    raw=True
)

logger.info("Result: {0}".format(op_result))
